package pl.topteam.dps.enums;

import java.util.ArrayList;
import java.util.List;

import pl.topteam.dps.enums.interfaces.EnumOpis;

public enum TypParametruOsoby implements EnumOpis {
// ustawienia dla recept (nazwy muszą rozpoczynać się od 'RECEPTA_')
	RECEPTA_ODDZIAL_NFZ("oddział NFZ osoby"),
	RECEPTA_UPRAWNIENIE("uprawnienie stosowane na receptach"),
	RECEPTA_CH_PRZEWLEKLE("uprawnienie choroby przewlekłe")
	;
	
	private static List<TypParametruOsoby> PARAMETRY_RECEPTY;
	
	static {
		// lista parametrów dotyczących recept
		PARAMETRY_RECEPTY = new ArrayList<>();
		
		for(TypParametruOsoby typParametru : TypParametruOsoby.values()) {
			//FIXME jeżeli są inne typy niż recepta to dać rozróżnianie tutaj
//			if(typParametru.name().startsWith("RECEPTA_")) {
				PARAMETRY_RECEPTY.add(typParametru);
//			}
		}
	}
	
	private String opis;
	
	private TypParametruOsoby(String opis) {
		this.opis = opis;
	}
	
	@Override
	public String getOpis() {
		return this.opis;
	}
	
	/**
	 * @return parametry przypisane osobie, które dotyczą recept
	 */
	public static List<TypParametruOsoby> parametryDotRecept() {
		return PARAMETRY_RECEPTY;
	}
}
