package pl.topteam.dps.enums;

import org.apache.commons.lang3.StringUtils;

import pl.topteam.dps.enums.interfaces.EnumOpis;
import pl.topteam.dps.enums.utils.ContextKey;

/*
 * ODEZWA DO PROGRAMISTÓW PROJEKTU DPS !!!
 *
 * DODAJĄC nowy typ parametru nie ukrywanego przed użytkownikiem należy uzwględnić:
 * - dla parametru, dodać plik parametr_NAZWA_TYPU.jsp do katalogu jsp/parametrSystemowy
 * 		oraz dodać jego mapowanie w pliku jsp/parametrSystemowy/opisyParametrow.jsp
 */
@SuppressWarnings("unchecked")
public enum TypParametruSystemowego implements EnumOpis {
//	TypParametruSystemowego(RodzajParametruSystemowego rodzajParametruSystemowego,
//			boolean ukryty, boolean pojedynczaWartosc, boolean czyWalidowacDomyslnie, String opisKrotki, String contextName, Object defaultContextValue,
//			Class enumClass, String collectionContextName),

// parametry jawne dla użytkownika
	GODZINA_DYZUR_DZIENNY(RodzajParametru.WARTOSC_INTEGER,
			false, true, true, "godzina rozpoczęcia dziennego dyżuru pielęgniarskiego", null, null,
			null, null),
	GODZINA_DYZUR_NOCNY(RodzajParametru.WARTOSC_INTEGER,
			false, true, true, "godzina rozpoczęcia nocnego dyżuru pielęgniarskiego", null, null,
			null, null),
	KWOTA_ZAPOMOGI_OSTRZEZENIE(RodzajParametru.WARTOSC_DECIMAL,
			false, false, false, "kwota udzielonej zapomogi (ostrzeżenie)", null, null,
			null, null),
	LICZBA_DNI_NIEOBECNOSCI_ZWROT(RodzajParametru.WARTOSC_INTEGER,
			false, false, true, "liczba dni nieobecności (do zwrotu ekwiwalentu)", null, null,
			null, null),
	LICZBA_DNI_NIEOBECNOSCI_ZWROT_MALOLETNI(RodzajParametru.WARTOSC_INTEGER,
			false, false, true, "liczba dni nieobecności (do zwrotu ekwiwalentu) dla m. małoletnich", null, null,
			null, null),
	LICZBA_WIERSZY_NA_STRONIE_LIST(RodzajParametru.WARTOSC_INTEGER,
			false, true, true, "liczba wierszy dla list danych", ContextKey.DPS_TABLE_LIST_LICZBA_WIERSZY_CONTEXT_KEY, 20,
			RecordOnPage.class, null),
	LICZBA_WIERSZY_NA_STRONIE_FORM(RodzajParametru.WARTOSC_INTEGER,
			false, true, true, "liczba wierszy dla formularzy tabelarycznych ", ContextKey.DPS_TABLE_FORM_LICZBA_WIERSZY_CONTEXT_KEY, 20,
			RecordOnPage.class, null),
	MAX_KWOTA_ODPL_MIESZK_STARE_ZASADY(RodzajParametru.WARTOSC_DECIMAL,
			false, false, true, "maks. kwota odpłatności mieszk. przyjętego wg starych zasad", null, null,
			null, null),
	MAX_LICZBA_DNI_WAZNOSC_RECEPTA(RodzajParametru.WARTOSC_INTEGER,
			false, true, true, "maks. liczba dni ważności recepty", "__liczba_dni_waznosc_recepta", 120,
			null, null),
	LICZBA_DNI_TERMIN_WAZNOSCI_DEC_KIER(RodzajParametru.WARTOSC_INTEGER,
			false, true, true, "powiadomienie - decyzje kierujące", null, null,
			null, null),
	LICZBA_DNI_TERMIN_WAZNOSCI_DOWOD_OS(RodzajParametru.WARTOSC_INTEGER,
			false, true, true, "powiadomienie - dowód osobisty", null, null,
			null, null),
	LICZBA_DNI_TERMIN_WAZNOSCI_DEC_ALIM_ODPL(RodzajParametru.WARTOSC_INTEGER,
			false, true, true, "powiadomienie - decyzje o alimentacji, odpłatności", null, null,
			null, null),
	LICZBA_DNI_TERMIN_WAZNOSCI_IPWM(RodzajParametru.WARTOSC_INTEGER,
			false, true, true, "powiadomienie - indywidualne plany wsparcia mieszkańca", null, null,
			null, null),
	LICZBA_DNI_TERMIN_WAZNOSCI_ORZECZENIE_N(RodzajParametru.WARTOSC_INTEGER,
			false, true, true, "powiadomienie - orzeczenie o niepełnosprawności", null, null,
			null, null),
	LICZBA_DNI_KONIEC_ZASILKU_STALEGO(RodzajParametru.WARTOSC_INTEGER,
			false, true, true, "powiadomienie - zasiłek stały", null, null,
			null, null),
	LICZBA_DNI_TERMIN_WAZNOSCI_MELDUNKU(RodzajParametru.WARTOSC_INTEGER,
			false, true, true, "powiadomienie - meldunek", null, null,
			null, null),
	LICZBA_DNI_RECEPTY(RodzajParametru.WARTOSC_INTEGER,
			false, true, true, "powiadomienie - wypisanie recept", null, null,
			null, null),
	LICZBA_DNI_TERMIN_WAZNOSCI_UMOWA(RodzajParametru.WARTOSC_INTEGER,
			false, true, true, "powiadomienie - umowy z mieszkańcami", null, null,
			null, null),
	LICZBA_MIESIECY_WAZNOSC_IPWM(RodzajParametru.WARTOSC_INTEGER,
			false, true, true, "długość czasu trwania planu wsparcia", null, null,
			null, null),
	PROCENT_DOCHODU_ODPLATNOSC(RodzajParametru.WARTOSC_DECIMAL,
			false, false, true, "procent dochodu mieszk. (odpłatność)", "__procent_dochodu_odplatnosc", null,
			null, null),
	SPOSOB_PODZIALU_KWOTY_ODPLATNOSCI(RodzajParametru.ENUM_OPIS,
			false, true, true, "sposób podziału kwoty odpłatności na dni", null, null,
			SposobRozbiciaKwotNaDni.class, null),
	SPOSOB_ROZL_ODPISU_NIEOBECNOSC(RodzajParametru.ENUM_OPIS,
			false, true, true, "sposób rozliczania odpisów za nieobecności", null, null,
			SposobRozliczaniaOdpisowNieobecnosc.class, null),
	SREDNI_KOSZT_UTRZYMANIA(RodzajParametru.WARTOSC_DECIMAL,
			false, false, true, "średni koszt utrzymania", null, null,
			null, null),

	// parametr nie jest obsługiwany w standardowy sposób (utworzona została oddzielna akcja)
	OBSLUGA_OKRESOW(RodzajParametru.WARTOSC_BOOLEAN,
			false, true, false, "uwzględnianie początku/końca okresów ograniczonych datami", null, null,
			null, NazwySlownikow.KOD_STOPNIA_POKREWIENSTWA.getNazwaServerContext()),
	ZOBOWIAZANI_ALIMENTACJA(RodzajParametru.SLOWO_ID_STRING,
			false, true, false, "członkowie rodzin domyślnie zobowiązani do alimentacji", null, null,
			null, NazwySlownikow.KOD_STOPNIA_POKREWIENSTWA.getNazwaServerContext()),

// parametry ukryte przed użytkownikiem
	PIERWSZE_URUCHOMIENIE(RodzajParametru.WARTOSC_BOOLEAN,
			true, true, false, "ustawiany w momencie uzupełnienia danych przy pierwszym uruchomieniu programu", "__pierwsze_uruchomienie", null,
			null, null),
	UWZGLEDNIAJ_POCZATEK_OKRESU(RodzajParametru.WARTOSC_BOOLEAN,
			true, true, false, "uwzględnij datę początku okresu", null, null,
			null, null),
	UWZGLEDNIAJ_KONIEC_OKRESU(RodzajParametru.WARTOSC_BOOLEAN,
			true, true, false, "uwzględnij datę końca okresu", null, null,
			null, null),
	;

	static {
		//walidacja wprowadzonych parametrów enuma

		for(TypParametruSystemowego typParametruSystemowego : TypParametruSystemowego.values()) {
			switch (typParametruSystemowego.getRodzajParametruSystemowego()) {
				case WARTOSC_BOOLEAN:
				case WARTOSC_DECIMAL:
				case WARTOSC_INTEGER:
				case WARTOSC_STRING:
					break;

				case ENUM_OPIS:
					if(typParametruSystemowego.getEnumClass() == null) {
						throw new IllegalArgumentException("Dla " + typParametruSystemowego.name() + " nie ustawiono parametru enumClass");
					}

					//jeżeli enum nie implementuje interfejsu enumOpis
					try {
						if(typParametruSystemowego.getEnumClass().getDeclaredMethod("getOpis", new Class[] {}) == null) {
							throw new IllegalArgumentException("W " + typParametruSystemowego.name() + " enumClass nie implementuje EnumOpis");
						}
					} catch(NoSuchMethodException nsmex) {
						throw new IllegalArgumentException("W " + typParametruSystemowego.name() + " enumClass nie implementuje EnumOpis");
					}
					break;

				case SLOWO_ID_INT:
				case SLOWO_ID_STRING:
				case SLOWO_KOD_INT:
				case SLOWO_KOD_STRING:
					if(StringUtils.isEmpty(typParametruSystemowego.getCollectionContextName())) {
						throw new IllegalArgumentException("Dla " + typParametruSystemowego.name() + " nie ustawiono parametru collectionContextName");
					}
					break;

				default:
					throw new IllegalArgumentException("nie ma takiego rodzaju parametru systemowego " + typParametruSystemowego.getRodzajParametruSystemowego());
			}
		}
	}

	private RodzajParametru rodzajParametruSystemowego;
	/**
	 * Warunkuje czy dopuszczalne jest występowanie kilku instancji
	 * danego parametru (false) czy może być tylko pojedyncza
	 * wartosc dla tego parametru (true)
	 */
	private boolean pojedynczaWartosc;

	/**
	 * Warunkuje czy pokazywać dany parametr użytkownikowi
	 */
	private boolean ukryty;
	/**
	 * - liczby mają być większe od 0,
	 * - tekst nie pusty,
	 * - wartość boolowska nie jest walidowana,
	 * - enum nie może być NULL,
	 * - slowo przedstawiane jako kod nie może być pustym znakiem
	 * - slowo jako id nie moze być NULL (i ponadto wieksze od 0)
	 */
	private boolean czyWalidowacDomyslnie;
	private String opis;
	private String contextName;
	/**
	 * Jeżeli null to parametr nie będzie ładowany do contextu
	 */
	private Object defaultContextValue;
	/**
	 * Jeżeli ustawiono rodzajParametruSystemowego na ENUM_OPIS
	 * to wtedy to pole nie może być null
	 */
	@SuppressWarnings("rawtypes")
	private Class enumClass;
	/**
	 * Jeżeli ustawiono rodzajParametruSystemowego na SLOWO_*
	 * to wtedy to pole musi wskazywać kolekcję umieszczoną albo
	 * w contextcie albo jako request attribute
	 */
	private String collectionContextName;

	@SuppressWarnings("rawtypes")
	private TypParametruSystemowego(RodzajParametru rodzajParametruSystemowego,
			boolean ukryty, boolean pojedynczaWartosc, boolean czyWalidowacDomyslnie, String opis, String contextName, Object defaultContextValue,
			Class enumClass, String collectionContextName) {
		this.ukryty = ukryty;
		this.rodzajParametruSystemowego = rodzajParametruSystemowego;
		this.pojedynczaWartosc = pojedynczaWartosc;
		this.czyWalidowacDomyslnie = czyWalidowacDomyslnie;
		this.opis = opis;
		this.contextName = contextName;
		this.defaultContextValue = defaultContextValue;
		this.enumClass = enumClass;
		this.collectionContextName = collectionContextName;
	}

	public RodzajParametru getRodzajParametruSystemowego() {
		return rodzajParametruSystemowego;
	}

	public String getContextName() {
		return contextName;
	}

	public void setContextName(String contextName) {
		this.contextName = contextName;
	}

	@Override
	public String getOpis() {
		return opis;
	}

	public boolean isPojedynczaWartosc() {
		return pojedynczaWartosc;
	}

	public boolean getPojedynczaWartosc() {
		return pojedynczaWartosc;
	}

	public boolean isCzyWalidowacDomyslnie() {
		return czyWalidowacDomyslnie;
	}

	public boolean isUkryty() {
		return ukryty;
	}

	public Object getDefaultContextValue() {
		return defaultContextValue;
	}

	@SuppressWarnings("rawtypes")
	public Class getEnumClass() {
		return enumClass;
	}

	public String getCollectionContextName() {
		return collectionContextName;
	}

	public String getName() {
		return this.name();
	}
}
