package pl.topteam.dps.enums;

import java.util.EnumSet;
import java.util.Set;

import pl.topteam.dps.enums.interfaces.EnumOpis;

public enum TypPrzypomnienia implements EnumOpis {
	// UWAGA !!! nazwy enumów nadawać tak by raczej się nie pokrywały początki tych nazw
	// albo należy zmienić implementację getByTypPrzypomnieniaName()
	DECYZJA_ALIM_ODPLATNOSCI(
			EnumSet.of(Branch.DOM_POMOCY, Branch.OSRODEK_OPIEKUNCZY), "zbliżająca sie data ważności dla decyzji o alimentacji, odpłatności"),
	DOWOD_OSOBISTY(
			EnumSet.of(Branch.DOM_POMOCY, Branch.FUNDACJA, Branch.MIESZKANIA_CHRONIONE), "zbliżający się termin ważności dowodu osobistego"),
	INFORMACJA_DODATKOWA(
			EnumSet.of(Branch.DOM_POMOCY, Branch.FUNDACJA, Branch.OSRODEK_OPIEKUNCZY, Branch.MIESZKANIA_CHRONIONE), "terminy ustawione dla informacji dodatkowych"),
	IPWM(EnumSet.of(Branch.DOM_POMOCY, Branch.FUNDACJA), "zbliżający się termin ważności IPWM"),
	MELDUNEK_CZASOWY(
			EnumSet.of(Branch.DOM_POMOCY, Branch.FUNDACJA, Branch.MIESZKANIA_CHRONIONE), "zbliżający się termin ważności meldunku czasowego mieszkańców"),
	ORZECZENIE_NIEPELNOSPRAWNOSC(
			EnumSet.of(Branch.DOM_POMOCY, Branch.FUNDACJA, Branch.OSRODEK_OPIEKUNCZY, Branch.MIESZKANIA_CHRONIONE), "zbliżający się termin ważności orzecz. o niepełnosprawności"),
	ROZLICZENIE_ZGON(
			EnumSet.of(Branch.DOM_POMOCY), "nierozliczone odpłatności zmarłych mieszkańców"),
	UMOWY(EnumSet.of(Branch.FUNDACJA), "zbliżający się termin ważności umowy")
	
// 
//	WYPISANIE_RECEPT(
//			EnumSet.of(Branch.DOM_POMOCY), "wypisanie recepty z uwagi na brak/kończące się leków/i w magazynie")
	;

	private Set<Branch> branches;
	private String opis;
	
	private TypPrzypomnienia(Set<Branch> branches, String opis) {
		this.branches = branches;
		this.opis = opis;
	}
	
	public Set<Branch> getBranches() {
		return branches;
	}
	
	@Override
	public String getOpis() {
		return this.opis;
	}
}
