package pl.topteam.dps.enums;

import java.util.List;

import pl.topteam.dps.enums.interfaces.EnumOpis;

import com.google.common.collect.ImmutableList;

/**
 * Enum zawiera listę uprawnień dostępnych w systemie TT DPS.
 * Uprawnienia dzielą się na:
 * <ul>
 * 		<li>tworzenie (C_),</li>
 * 		<li>czytanie/przeglądanie (R_),</li>
 * 		<li>aktualizacja (U_),</li>
 * 		<li>usuwanie (D_).</li>
 * </ul>
 *
 * Dla każdego nowego uprawnienia należy utworzyć jego cztery odmiany
 * zgodnie z przedrostami podanymi w nawiasach powyżej. Po przedrostku dla każdego
 * takigo uprawnienia powinien wystąpić taki sam ciąg znaków dla każdej z tych czterech
 * odmian C, R, U, D czyli:<br/>
 * jeśli chcemy utworzyć uprawnienie o nazwie 'DEC_KIER' to do emuna wpisujemy jego cztery odmiany:
 * C_DEC_KIER,<br/>
 * R_DEC_KIER<br/>
 * U_DEC_KIER<br/>
 * D_DEC_KIER<br/>
 * nadając im przy tym odpowiednią grupę uprawnień i opis dla użytkownika.
 *
 * Dzięki stosowaniu się do tych zasad wyświetlenie i edycja uprawnień na formatkach staje
 * się znacząco uproszczona.
 *
 * UWAGA !!!
 * Dodatkowo występują uprawnienia strategiczne z punktu funkcjonowania całego programu.
 * Takim sztandarowym przykładem jest uprawnienie do edycji grup (czyli przypisywania uprawnień
 * dla pracowników). W programie musi być co najmniej jeden pracownik, który może się potencjalnie zalogować
 * oraz zmieniać te uprawnienia.
 * TAKIE UPRAWNIENIA NALEŻY DOPISAĆ DO LISTY UPRAWNIEŃ STRATEGICZNYCH !!!
 */
public enum Uprawnienie implements EnumOpis {
	/**
	 * każdy użytkownik, który jest zarejestrowany w programie musi mieć takie uprawnienie
	 */
	USER(TypUprawnienia.UZYTKOWNIK_PROGRAMU),

// aktualizacja bazy
//	C_AKTUALIZACJA_BAZY(TypUprawnienia.AKTUALIZACJA_BAZY),
	R_AKTUALIZACJA_BAZY(TypUprawnienia.AKTUALIZACJA_BAZY),
//	U_AKTUALIZACJA_BAZY(TypUprawnienia.AKTUALIZACJA_BAZY),
//	D_AKTUALIZACJA_BAZY(TypUprawnienia.AKTUALIZACJA_BAZY),

// autonumeracja
//	C_AUTONUMERACJA(TypUprawnienia.AUTONUMERACJA),
	R_AUTONUMERACJA(TypUprawnienia.AUTONUMERACJA),
	U_AUTONUMERACJA(TypUprawnienia.AUTONUMERACJA),
//	D_AUTONUMERACJA(TypUprawnienia.AUTONUMERACJA),

// czas pracy lampy UV
	C_CZAS_PRACY_UV(TypUprawnienia.CZAS_PRACY_UV),
	R_CZAS_PRACY_UV(TypUprawnienia.CZAS_PRACY_UV),
	U_CZAS_PRACY_UV(TypUprawnienia.CZAS_PRACY_UV),
	D_CZAS_PRACY_UV(TypUprawnienia.CZAS_PRACY_UV),

// decyzje kierujące
	C_DEC_KIER(TypUprawnienia.DEC_KIER),
	R_DEC_KIER(TypUprawnienia.DEC_KIER),
	U_DEC_KIER(TypUprawnienia.DEC_KIER),
	D_DEC_KIER(TypUprawnienia.DEC_KIER),

// decyzja o alimentacji
	C_DEC_ALIM(TypUprawnienia.DEC_ALIM),
	R_DEC_ALIM(TypUprawnienia.DEC_ALIM),
	U_DEC_ALIM(TypUprawnienia.DEC_ALIM),
	D_DEC_ALIM(TypUprawnienia.DEC_ALIM),

// decyzja o alimentacji
	C_DEC_ODPL(TypUprawnienia.DEC_ODPL),
	R_DEC_ODPL(TypUprawnienia.DEC_ODPL),
	U_DEC_ODPL(TypUprawnienia.DEC_ODPL),
	D_DEC_ODPL(TypUprawnienia.DEC_ODPL),

// decyzja uchylająca
	C_DEC_UCH(TypUprawnienia.DEC_UCH),
	R_DEC_UCH(TypUprawnienia.DEC_UCH),
	U_DEC_UCH(TypUprawnienia.DEC_UCH),
	D_DEC_UCH(TypUprawnienia.DEC_UCH),

// decyzja umieszczająca
	C_DEC_UM(TypUprawnienia.DEC_UM),
	R_DEC_UM(TypUprawnienia.DEC_UM),
	U_DEC_UM(TypUprawnienia.DEC_UM),
	D_DEC_UM(TypUprawnienia.DEC_UM),

// decyzja wygaszajaca
	C_DEC_WYG(TypUprawnienia.DEC_WYG),
	R_DEC_WYG(TypUprawnienia.DEC_WYG),
	U_DEC_WYG(TypUprawnienia.DEC_WYG),
	D_DEC_WYG(TypUprawnienia.DEC_WYG),

// dane DPS
//	C_DANE_DPS(TypUprawnienia.DANE_DPS),
	R_DANE_DPS(TypUprawnienia.DANE_DPS),
	U_DANE_DPS(TypUprawnienia.DANE_DPS),
//	D_DANE_DPS(TypUprawnienia.DANE_DPS),

//dziennik operacji
//	C_DZIENNIK(TypUprawnienia.DZIENNIK),
	R_DZIENNIK(TypUprawnienia.DZIENNIK),
//	U_DZIENNIK(TypUprawnienia.DZIENNIK),
//	D_DZIENNIK(TypUprawnienia.DZIENNIK),

// dawkowanie leków
	C_DAWKOWANIE(TypUprawnienia.DAWKOWANIE),
	R_DAWKOWANIE(TypUprawnienia.DAWKOWANIE),
	U_DAWKOWANIE(TypUprawnienia.DAWKOWANIE),
	D_DAWKOWANIE(TypUprawnienia.DAWKOWANIE),

// depozyt
	C_DEPOZYT(TypUprawnienia.DEPOZYT),
	R_DEPOZYT(TypUprawnienia.DEPOZYT),
	U_DEPOZYT(TypUprawnienia.DEPOZYT),
	D_DEPOZYT(TypUprawnienia.DEPOZYT),

// dowód osobisty
	C_DWD_OS(TypUprawnienia.DWD_OS),
	R_DWD_OS(TypUprawnienia.DWD_OS),
	U_DWD_OS(TypUprawnienia.DWD_OS),
	D_DWD_OS(TypUprawnienia.DWD_OS),

// formaty plików importu
	C_FORMAT(TypUprawnienia.FORMAT),
	R_FORMAT(TypUprawnienia.FORMAT),
	U_FORMAT(TypUprawnienia.FORMAT),
	D_FORMAT(TypUprawnienia.FORMAT),

// faktury VAT
//	C_FAKTURY(TypUprawnienia.FAKTURY),
	R_FAKTURY(TypUprawnienia.FAKTURY),
	U_FAKTURY(TypUprawnienia.FAKTURY),
	D_FAKTURY(TypUprawnienia.FAKTURY),

// grupy uprawnień użytkowników
	C_GRUPA_PRACOW(TypUprawnienia.GRUPA_PRACOW),
	R_GRUPA_PRACOW(TypUprawnienia.GRUPA_PRACOW),
	U_GRUPA_PRACOW(TypUprawnienia.GRUPA_PRACOW),
	D_GRUPA_PRACOW(TypUprawnienia.GRUPA_PRACOW),

// import danych z ARISCO
	C_IMPORT_ARISCO(TypUprawnienia.IMPORT_ARISCO),
	R_IMPORT_ARISCO(TypUprawnienia.IMPORT_ARISCO),
//	U_IMPORT_ARISCO(TypUprawnienia.IMPORT_ARISCO),
//	D_IMPORT_ARISCO(TypUprawnienia.IMPORT_ARISCO),

// import danych z TT DOS
	C_IMPORT_TTDOS(TypUprawnienia.IMPORT_TTDOS),
	R_IMPORT_TTDOS(TypUprawnienia.IMPORT_TTDOS),
//	U_IMPORT_TTDOS(TypUprawnienia.IMPORT_TTDOS),
//	D_IMPORT_TTDOS(TypUprawnienia.IMPORT_TTDOS),

// informacja dodatkowa (DEFINICJA)
	C_INFOR_DOD_DEF(TypUprawnienia.INFOR_DOD_DEF),
	R_INFOR_DOD_DEF(TypUprawnienia.INFOR_DOD_DEF),
	U_INFOR_DOD_DEF(TypUprawnienia.INFOR_DOD_DEF),
	D_INFOR_DOD_DEF(TypUprawnienia.INFOR_DOD_DEF),

// informacja dodatkowa (WPROWADZANIE)
	C_INFOR_DOD_REAL(TypUprawnienia.INFOR_DOD_REAL),
	R_INFOR_DOD_REAL(TypUprawnienia.INFOR_DOD_REAL),
	U_INFOR_DOD_REAL(TypUprawnienia.INFOR_DOD_REAL),
	D_INFOR_DOD_REAL(TypUprawnienia.INFOR_DOD_REAL),

// instytucja dopłacająca do utrzymania mieszkańca
	C_INSTYTUCJA_DOPLACAJACA(TypUprawnienia.INSTYTUCJA_DOPLACAJACA),
	R_INSTYTUCJA_DOPLACAJACA(TypUprawnienia.INSTYTUCJA_DOPLACAJACA),
	U_INSTYTUCJA_DOPLACAJACA(TypUprawnienia.INSTYTUCJA_DOPLACAJACA),
	D_INSTYTUCJA_DOPLACAJACA(TypUprawnienia.INSTYTUCJA_DOPLACAJACA),

// interwencja organów ścigania
	C_INTERWENCJA_ORG_SCI(TypUprawnienia.INTERWENCJA_ORG_SCI),
	R_INTERWENCJA_ORG_SCI(TypUprawnienia.INTERWENCJA_ORG_SCI),
	U_INTERWENCJA_ORG_SCI(TypUprawnienia.INTERWENCJA_ORG_SCI),
	D_INTERWENCJA_ORG_SCI(TypUprawnienia.INTERWENCJA_ORG_SCI),

// interwencja organów ścigania
	C_INTERWENCJA_POG_RAT(TypUprawnienia.INTERWENCJA_POG_RAT),
	R_INTERWENCJA_POG_RAT(TypUprawnienia.INTERWENCJA_POG_RAT),
	U_INTERWENCJA_POG_RAT(TypUprawnienia.INTERWENCJA_POG_RAT),
	D_INTERWENCJA_POG_RAT(TypUprawnienia.INTERWENCJA_POG_RAT),

// katalog usług
	C_KAT_USLUG(TypUprawnienia.KAT_USLUG),
	R_KAT_USLUG(TypUprawnienia.KAT_USLUG),
	U_KAT_USLUG(TypUprawnienia.KAT_USLUG),
	D_KAT_USLUG(TypUprawnienia.KAT_USLUG),

// katalog uslug (wprowadzanie czynnosci przez pracownika)
	C_KAT_USL_CZYNN(TypUprawnienia.KAT_USLUG_CZYNN),
	R_KAT_USL_CZYNN(TypUprawnienia.KAT_USLUG_CZYNN),
//	U_KAT_USL_CZYNN(TypUprawnienia.KAT_USLUG_CZYNN),
	D_KAT_USL_CZYNN(TypUprawnienia.KAT_USLUG_CZYNN),

// kopia bazy danych
	C_KOPIA_BAZY(TypUprawnienia.KOPIA_BAZY),
	R_KOPIA_BAZY(TypUprawnienia.KOPIA_BAZY),
//	U_KOPIA_BAZY(TypUprawnienia.KOPIA_BAZY),
//	D_KOPIA_BAZY(TypUprawnienia.KOPIA_BAZY),

// kwalifikacja pielęgniarska
	C_KWALIFIKACJA_PIEL(TypUprawnienia.KWALIFIKACJA_PIEL),
	R_KWALIFIKACJA_PIEL(TypUprawnienia.KWALIFIKACJA_PIEL),
	U_KWALIFIKACJA_PIEL(TypUprawnienia.KWALIFIKACJA_PIEL),
	D_KWALIFIKACJA_PIEL(TypUprawnienia.KWALIFIKACJA_PIEL),

// podglad ogólny danych osób
//	C_LISTA_OSOB(TypUprawnienia.LISTA_OSOB),
	R_LISTA_OSOB(TypUprawnienia.LISTA_OSOB),
//	U_LISTA_OSOB(TypUprawnienia.LISTA_OSOB),
//	D_LISTA_OSOB(TypUprawnienia.LISTA_OSOB),

// magazyn leków doraźnych
	C_MG_DORAZNY(TypUprawnienia.MG_DORAZNY),
	R_MG_DORAZNY(TypUprawnienia.MG_DORAZNY),
	U_MG_DORAZNY(TypUprawnienia.MG_DORAZNY),
	D_MG_DORAZNY(TypUprawnienia.MG_DORAZNY),

// magazyn leków na recepty
	C_MG_RECEPTY(TypUprawnienia.MG_RECEPTY),
	R_MG_RECEPTY(TypUprawnienia.MG_RECEPTY),
	U_MG_RECEPTY(TypUprawnienia.MG_RECEPTY),
	D_MG_RECEPTY(TypUprawnienia.MG_RECEPTY),

// meldunek
	C_MELDUNEK(TypUprawnienia.MELDUNEK),
	R_MELDUNEK(TypUprawnienia.MELDUNEK),
	U_MELDUNEK(TypUprawnienia.MELDUNEK),
	D_MELDUNEK(TypUprawnienia.MELDUNEK),

// miejsce pobytu/skierowań mieszkańców
	C_MIEJSCE_POBYTU(TypUprawnienia.MIEJSCE_POBYTU),
	R_MIEJSCE_POBYTU(TypUprawnienia.MIEJSCE_POBYTU),
	U_MIEJSCE_POBYTU(TypUprawnienia.MIEJSCE_POBYTU),
	D_MIEJSCE_POBYTU(TypUprawnienia.MIEJSCE_POBYTU),

// mieszkaniec
	C_MIESZKANIEC(TypUprawnienia.MIESZKANIEC),
	R_MIESZKANIEC(TypUprawnienia.MIESZKANIEC),
	U_MIESZKANIEC(TypUprawnienia.MIESZKANIEC),
	D_MIESZKANIEC(TypUprawnienia.MIESZKANIEC),

// członkowie rodziny mieszkańca
	C_MIESZKANIEC_CZLR(TypUprawnienia.MIESZKANIEC_CZLR),
	R_MIESZKANIEC_CZLR(TypUprawnienia.MIESZKANIEC_CZLR),
	U_MIESZKANIEC_CZLR(TypUprawnienia.MIESZKANIEC_CZLR),
	D_MIESZKANIEC_CZLR(TypUprawnienia.MIESZKANIEC_CZLR),

// monitorowanie mieszkańców
	C_MONITOROWANIE(TypUprawnienia.MONITOROWANIE),
	R_MONITOROWANIE(TypUprawnienia.MONITOROWANIE),
	U_MONITOROWANIE(TypUprawnienia.MONITOROWANIE),
	D_MONITOROWANIE(TypUprawnienia.MONITOROWANIE),

// naliczanie odpłatności
	C_NALICZANIE_ODPL(TypUprawnienia.NALICZANIE_ODPL),
	R_NALICZANIE_ODPL(TypUprawnienia.NALICZANIE_ODPL),
	U_NALICZANIE_ODPL(TypUprawnienia.NALICZANIE_ODPL),
	D_NALICZANIE_ODPL(TypUprawnienia.NALICZANIE_ODPL),

// nieobecnosc
	C_NIEOBECNOSC(TypUprawnienia.NIEOBECNOSC),
	R_NIEOBECNOSC(TypUprawnienia.NIEOBECNOSC),
	U_NIEOBECNOSC(TypUprawnienia.NIEOBECNOSC),
	D_NIEOBECNOSC(TypUprawnienia.NIEOBECNOSC),

// nieobecność informacja
	C_NIEOBECNOSC_INFORMACJA(TypUprawnienia.NIEOBECNOSC_INFORMACJA),
	R_NIEOBECNOSC_INFORMACJA(TypUprawnienia.NIEOBECNOSC_INFORMACJA),
	U_NIEOBECNOSC_INFORMACJA(TypUprawnienia.NIEOBECNOSC_INFORMACJA),
	D_NIEOBECNOSC_INFORMACJA(TypUprawnienia.NIEOBECNOSC_INFORMACJA),

// ocena mieszkańca w ustalonej skali
	C_OCENA_WG_SKALI(TypUprawnienia.OCENA_WG_SKALI),
	R_OCENA_WG_SKALI(TypUprawnienia.OCENA_WG_SKALI),
	U_OCENA_WG_SKALI(TypUprawnienia.OCENA_WG_SKALI),
	D_OCENA_WG_SKALI(TypUprawnienia.OCENA_WG_SKALI),

// odpady medyczne
	C_ODPADY_MEDYCZNE(TypUprawnienia.ODPADY_MEDYCZNE),
	R_ODPADY_MEDYCZNE(TypUprawnienia.ODPADY_MEDYCZNE),
	U_ODPADY_MEDYCZNE(TypUprawnienia.ODPADY_MEDYCZNE),
	D_ODPADY_MEDYCZNE(TypUprawnienia.ODPADY_MEDYCZNE),

// odpisy
	C_ODPIS(TypUprawnienia.ODPIS),
	R_ODPIS(TypUprawnienia.ODPIS),
	U_ODPIS(TypUprawnienia.ODPIS),
	D_ODPIS(TypUprawnienia.ODPIS),

// osoba oczekująca
	C_OCZEKUJACY(TypUprawnienia.OCZEKUJACY),
	R_OCZEKUJACY(TypUprawnienia.OCZEKUJACY),
	U_OCZEKUJACY(TypUprawnienia.OCZEKUJACY),
	D_OCZEKUJACY(TypUprawnienia.OCZEKUJACY),

// wyliczanie odpłatności mieszkańca
	C_ODPLATNOSC(TypUprawnienia.ODPLATNOSC),
	R_ODPLATNOSC(TypUprawnienia.ODPLATNOSC),
	U_ODPLATNOSC(TypUprawnienia.ODPLATNOSC),
	D_ODPLATNOSC(TypUprawnienia.ODPLATNOSC),

// odwiedziny mieszkańca
	C_ODWIEDZINY(TypUprawnienia.ODWIEDZINY),
	R_ODWIEDZINY(TypUprawnienia.ODWIEDZINY),
	U_ODWIEDZINY(TypUprawnienia.ODWIEDZINY),
	D_ODWIEDZINY(TypUprawnienia.ODWIEDZINY),

// orzeczenie o niepełnosprawności
	C_ORZECZ_NIEP(TypUprawnienia.ORZECZ_NIEP),
	R_ORZECZ_NIEP(TypUprawnienia.ORZECZ_NIEP),
	U_ORZECZ_NIEP(TypUprawnienia.ORZECZ_NIEP),
	D_ORZECZ_NIEP(TypUprawnienia.ORZECZ_NIEP),

	// orzeczenie sądu
	C_POSTANOWIENIE_SADU(TypUprawnienia.POSTANOWIENIE_SADU),
	R_POSTANOWIENIE_SADU(TypUprawnienia.POSTANOWIENIE_SADU),
	U_POSTANOWIENIE_SADU(TypUprawnienia.POSTANOWIENIE_SADU),
	D_POSTANOWIENIE_SADU(TypUprawnienia.POSTANOWIENIE_SADU),

//parametr systemowy
	C_PARAM_SYS(TypUprawnienia.PARAM_SYS),
	R_PARAM_SYS(TypUprawnienia.PARAM_SYS),
	U_PARAM_SYS(TypUprawnienia.PARAM_SYS),
	D_PARAM_SYS(TypUprawnienia.PARAM_SYS),

// pobranie krwi do badań
	C_POBR_MATERIALU_BADANIA(TypUprawnienia.POBR_MATERIALU_BADANIA),
	R_POBR_MATERIALU_BADANIA(TypUprawnienia.POBR_MATERIALU_BADANIA),
	U_POBR_MATERIALU_BADANIA(TypUprawnienia.POBR_MATERIALU_BADANIA),
	D_POBR_MATERIALU_BADANIA(TypUprawnienia.POBR_MATERIALU_BADANIA),

// pomiar glikemii
	C_POMIAR_ALKOMATEM(TypUprawnienia.POMIAR_ALKOMATEM),
	R_POMIAR_ALKOMATEM(TypUprawnienia.POMIAR_ALKOMATEM),
	U_POMIAR_ALKOMATEM(TypUprawnienia.POMIAR_ALKOMATEM),
	D_POMIAR_ALKOMATEM(TypUprawnienia.POMIAR_ALKOMATEM),

// pomiar glikemii
	C_POMIAR_CISN_TETN(TypUprawnienia.POMIAR_CISN_TETN),
	R_POMIAR_CISN_TETN(TypUprawnienia.POMIAR_CISN_TETN),
	U_POMIAR_CISN_TETN(TypUprawnienia.POMIAR_CISN_TETN),
	D_POMIAR_CISN_TETN(TypUprawnienia.POMIAR_CISN_TETN),

// pomiar glikemii
	C_POMIAR_GLIKEMII(TypUprawnienia.POMIAR_GLIKEMII),
	R_POMIAR_GLIKEMII(TypUprawnienia.POMIAR_GLIKEMII),
	U_POMIAR_GLIKEMII(TypUprawnienia.POMIAR_GLIKEMII),
	D_POMIAR_GLIKEMII(TypUprawnienia.POMIAR_GLIKEMII),

// pomiar glikemii
	C_POMIAR_TEMP_CIALA(TypUprawnienia.POMIAR_TEMP_CIALA),
	R_POMIAR_TEMP_CIALA(TypUprawnienia.POMIAR_TEMP_CIALA),
	U_POMIAR_TEMP_CIALA(TypUprawnienia.POMIAR_TEMP_CIALA),
	D_POMIAR_TEMP_CIALA(TypUprawnienia.POMIAR_TEMP_CIALA),

// raport dyżuru pielęgniarski (tworzenie)
	C_RAPORT_DYZ(TypUprawnienia.RAPORT_DYZ),
	R_RAPORT_DYZ(TypUprawnienia.RAPORT_DYZ),
	U_RAPORT_DYZ(TypUprawnienia.RAPORT_DYZ),
	D_RAPORT_DYZ(TypUprawnienia.RAPORT_DYZ),

// raport dyżuru pielęgniarski (definicja)
	C_RAPORT_DYZ_DEF(TypUprawnienia.RAPORT_DYZ_DEF),
	R_RAPORT_DYZ_DEF(TypUprawnienia.RAPORT_DYZ_DEF),
	U_RAPORT_DYZ_DEF(TypUprawnienia.RAPORT_DYZ_DEF),
	D_RAPORT_DYZ_DEF(TypUprawnienia.RAPORT_DYZ_DEF),

// realizacja leków
	C_REALIZACJA_LEKOW(TypUprawnienia.REALIZACJA_LEKOW),
	R_REALIZACJA_LEKOW(TypUprawnienia.REALIZACJA_LEKOW),
	U_REALIZACJA_LEKOW(TypUprawnienia.REALIZACJA_LEKOW),
	D_REALIZACJA_LEKOW(TypUprawnienia.REALIZACJA_LEKOW),

// realizacja leków
	C_REALIZACJA_WYROBOW_MED(TypUprawnienia.REALIZACJA_WYROBOW_MED),
	R_REALIZACJA_WYROBOW_MED(TypUprawnienia.REALIZACJA_WYROBOW_MED),
	U_REALIZACJA_WYROBOW_MED(TypUprawnienia.REALIZACJA_WYROBOW_MED),
	D_REALIZACJA_WYROBOW_MED(TypUprawnienia.REALIZACJA_WYROBOW_MED),

// recepty
	C_RECEPTY(TypUprawnienia.RECEPTY),
	R_RECEPTY(TypUprawnienia.RECEPTY),
	U_RECEPTY(TypUprawnienia.RECEPTY),
	D_RECEPTY(TypUprawnienia.RECEPTY),

// recepty - faktury
	C_RECEPTY_FAKTURY(TypUprawnienia.RECEPTY_FAKTURY),
	R_RECEPTY_FAKTURY(TypUprawnienia.RECEPTY_FAKTURY),
	U_RECEPTY_FAKTURY(TypUprawnienia.RECEPTY_FAKTURY),
	D_RECEPTY_FAKTURY(TypUprawnienia.RECEPTY_FAKTURY),

// indywidualny plan wsparcia mieszkańca
	C_PLAN_WSPARCIA_MIESZKANCA(TypUprawnienia.PLAN_WSPARCIA_MIESZKANCA),
	R_PLAN_WSPARCIA_MIESZKANCA(TypUprawnienia.PLAN_WSPARCIA_MIESZKANCA),
	U_PLAN_WSPARCIA_MIESZKANCA(TypUprawnienia.PLAN_WSPARCIA_MIESZKANCA),
	D_PLAN_WSPARCIA_MIESZKANCA(TypUprawnienia.PLAN_WSPARCIA_MIESZKANCA),

// świadczenia pobierane przez mieszkańca
	C_POB_SWIAD(TypUprawnienia.POB_SWIAD),
	R_POB_SWIAD(TypUprawnienia.POB_SWIAD),
	U_POB_SWIAD(TypUprawnienia.POB_SWIAD),
	D_POB_SWIAD(TypUprawnienia.POB_SWIAD),

// polityka bezpieczeństwa
//	C_POLITYKA_BEZPIECZENSTWA(TypUprawnienia.POLITYKA_BEZPIECZENSTWA),
	R_POLITYKA_BEZPIECZENSTWA(TypUprawnienia.POLITYKA_BEZPIECZENSTWA),
	U_POLITYKA_BEZPIECZENSTWA(TypUprawnienia.POLITYKA_BEZPIECZENSTWA),
//	D_POLITYKA_BEZPIECZENSTWA(TypUprawnienia.POLITYKA_BEZPIECZENSTWA),

// pory dnia podawania leków
	C_PORA_DNIA(TypUprawnienia.PORA_DNIA),
	R_PORA_DNIA(TypUprawnienia.PORA_DNIA),
	U_PORA_DNIA(TypUprawnienia.PORA_DNIA),
	D_PORA_DNIA(TypUprawnienia.PORA_DNIA),

// pracownik
	C_PRACOWNIK(TypUprawnienia.PRACOWNIK),
	R_PRACOWNIK(TypUprawnienia.PRACOWNIK),
	U_PRACOWNIK(TypUprawnienia.PRACOWNIK),
	D_PRACOWNIK(TypUprawnienia.PRACOWNIK),

// druki przelewów
	C_PRZELEW_DRUK(TypUprawnienia.PRZELEW_DRUK),
	R_PRZELEW_DRUK(TypUprawnienia.PRZELEW_DRUK),
	U_PRZELEW_DRUK(TypUprawnienia.PRZELEW_DRUK),
	D_PRZELEW_DRUK(TypUprawnienia.PRZELEW_DRUK),

// raporty
//	C_RAPORTY(TypUprawnienia.RAPORTY),
	R_RAPORTY(TypUprawnienia.RAPORTY),
//	U_RAPORTY(TypUprawnienia.RAPORTY),
//	D_RAPORTY(TypUprawnienia.RAPORTY),

// skala oceny pacjenta
	C_SKALA_OCENY(TypUprawnienia.SKALA_OCENY),
	R_SKALA_OCENY(TypUprawnienia.SKALA_OCENY),
	U_SKALA_OCENY(TypUprawnienia.SKALA_OCENY),
	D_SKALA_OCENY(TypUprawnienia.SKALA_OCENY),

// słowa w słownikach edytowalnych
	C_SLOWO(TypUprawnienia.SLOWO),
	R_SLOWO(TypUprawnienia.SLOWO),
	U_SLOWO(TypUprawnienia.SLOWO),
	D_SLOWO(TypUprawnienia.SLOWO),

// słownik leków
	C_SLOWNIK_LEKOW(TypUprawnienia.SLOWNIK_LEKOW),
	R_SLOWNIK_LEKOW(TypUprawnienia.SLOWNIK_LEKOW),
//	U_SLOWNIK_LEKOW(TypUprawnienia.SLOWNIK_LEKOW),
	D_SLOWNIK_LEKOW(TypUprawnienia.SLOWNIK_LEKOW),

// sprawozdania
	C_SPRAWOZDANIE(TypUprawnienia.SPRAWOZDANIE),
	R_SPRAWOZDANIE(TypUprawnienia.SPRAWOZDANIE),
	U_SPRAWOZDANIE(TypUprawnienia.SPRAWOZDANIE),
	D_SPRAWOZDANIE(TypUprawnienia.SPRAWOZDANIE),

// świadczenie (dla dziennego pobytu)
	C_SWIADCZENIE(TypUprawnienia.SWIADCZENIE),
	R_SWIADCZENIE(TypUprawnienia.SWIADCZENIE),
	U_SWIADCZENIE(TypUprawnienia.SWIADCZENIE),
	D_SWIADCZENIE(TypUprawnienia.SWIADCZENIE),

// świadczenie (rozliczenia)
	C_SWIADCZENIE_ROZLICZENIA(TypUprawnienia.SWIADCZENIE_ROZLICZENIA),
	R_SWIADCZENIE_ROZLICZENIA(TypUprawnienia.SWIADCZENIE_ROZLICZENIA),
	U_SWIADCZENIE_ROZLICZENIA(TypUprawnienia.SWIADCZENIE_ROZLICZENIA),
	D_SWIADCZENIE_ROZLICZENIA(TypUprawnienia.SWIADCZENIE_ROZLICZENIA),

// świadczenie realizacja
	C_SWIADCZENIE_REALIZACJA(TypUprawnienia.SWIADCZENIE_REALIZACJA),
	R_SWIADCZENIE_REALIZACJA(TypUprawnienia.SWIADCZENIE_REALIZACJA),
	U_SWIADCZENIE_REALIZACJA(TypUprawnienia.SWIADCZENIE_REALIZACJA),
	D_SWIADCZENIE_REALIZACJA(TypUprawnienia.SWIADCZENIE_REALIZACJA),

// szablony wydruku
	C_SZABLON_WYDRUKU(TypUprawnienia.SZABLON_WYDRUKU),
	R_SZABLON_WYDRUKU(TypUprawnienia.SZABLON_WYDRUKU),
	U_SZABLON_WYDRUKU(TypUprawnienia.SZABLON_WYDRUKU),
	D_SZABLON_WYDRUKU(TypUprawnienia.SZABLON_WYDRUKU),

// tomcat logi
//	C_TOMCAT_LOGI(TypUprawnienia.TOMCAT_LOGI),
	R_TOMCAT_LOGI(TypUprawnienia.TOMCAT_LOGI),
//	U_TOMCAT_LOGI(TypUprawnienia.TOMCAT_LOGI),
//	D_TOMCAT_LOGI(TypUprawnienia.TOMCAT_LOGI),

	C_UMOWA(TypUprawnienia.UMOWA),
	R_UMOWA(TypUprawnienia.UMOWA),
	U_UMOWA(TypUprawnienia.UMOWA),
	D_UMOWA(TypUprawnienia.UMOWA),

	C_UMOWA_APTEKA(TypUprawnienia.UMOWA_APTEKA),
	R_UMOWA_APTEKA(TypUprawnienia.UMOWA_APTEKA),
	U_UMOWA_APTEKA(TypUprawnienia.UMOWA_APTEKA),
	D_UMOWA_APTEKA(TypUprawnienia.UMOWA_APTEKA),

// wpłaty dla ustalonych płatności mieszkańca
	C_WPLATY_PLATNOSC(TypUprawnienia.WPLATY_PLATNOSC),
	R_WPLATY_PLATNOSC(TypUprawnienia.WPLATY_PLATNOSC),
	U_WPLATY_PLATNOSC(TypUprawnienia.WPLATY_PLATNOSC),
	D_WPLATY_PLATNOSC(TypUprawnienia.WPLATY_PLATNOSC),

// wyrob medyczny
	C_WYROB_MEDYCZNY(TypUprawnienia.WYROB_MEDYCZNY),
	R_WYROB_MEDYCZNY(TypUprawnienia.WYROB_MEDYCZNY),
	U_WYROB_MEDYCZNY(TypUprawnienia.WYROB_MEDYCZNY),
	D_WYROB_MEDYCZNY(TypUprawnienia.WYROB_MEDYCZNY),

// faktury VAT (wyroby medyczne)
	C_WYROB_MED_FAKTURY(TypUprawnienia.WYROB_MED_FAKTURY),
	R_WYROB_MED_FAKTURY(TypUprawnienia.WYROB_MED_FAKTURY),
//	U_WYROB_MED_FAKTURY(TypUprawnienia.WYROB_MED_FAKTURY),
//	D_WYROB_MED_FAKTURY(TypUprawnienia.WYROB_MED_FAKTURY),

// zapomogi
	C_ZAPOMOGA(TypUprawnienia.ZAPOMOGA),
	R_ZAPOMOGA(TypUprawnienia.ZAPOMOGA),
	U_ZAPOMOGA(TypUprawnienia.ZAPOMOGA),
	D_ZAPOMOGA(TypUprawnienia.ZAPOMOGA),

// zadania czasowe
//	C_ZADANIE_CZASOWE(TypUprawnienia.ZADANIE_CZASOWE),
	R_ZADANIE_CZASOWE(TypUprawnienia.ZADANIE_CZASOWE),
	U_ZADANIE_CZASOWE(TypUprawnienia.ZADANIE_CZASOWE),
//	D_ZADANIE_CZASOWE(TypUprawnienia.ZADANIE_CZASOWE),

	C_ZALECENIE_LEKARSKIE(TypUprawnienia.ZALECENIE_LEKARSKIE),
	R_ZALECENIE_LEKARSKIE(TypUprawnienia.ZALECENIE_LEKARSKIE),
	U_ZALECENIE_LEKARSKIE(TypUprawnienia.ZALECENIE_LEKARSKIE),
	D_ZALECENIE_LEKARSKIE(TypUprawnienia.ZALECENIE_LEKARSKIE),

// zebranie ZTO
	C_ZEBRANIE_ZTO(TypUprawnienia.ZEBRANIE_ZTO),
	R_ZEBRANIE_ZTO(TypUprawnienia.ZEBRANIE_ZTO),
	U_ZEBRANIE_ZTO(TypUprawnienia.ZEBRANIE_ZTO),
	D_ZEBRANIE_ZTO(TypUprawnienia.ZEBRANIE_ZTO),

// zwroty
	C_ZWROT(TypUprawnienia.ZWROT),
	R_ZWROT(TypUprawnienia.ZWROT),
	U_ZWROT(TypUprawnienia.ZWROT),
	D_ZWROT(TypUprawnienia.ZWROT),
	;

	// lista uprawnień strategicznych
	private static List<Uprawnienie> UPRAWNIENIA_STRATEGICZNE;
	static {
		UPRAWNIENIA_STRATEGICZNE = ImmutableList.of(Uprawnienie.R_GRUPA_PRACOW, Uprawnienie.U_GRUPA_PRACOW);
	}

	/**
	 * Występują w programie uprawnienia strategiczne z punktu jego funkcjonowania.
	 * Takim sztandarowym przykładem jest uprawnienie do edycji grup (czyli przypisywania uprawnień
	 * dla pracowników). W programie musi być co najmniej jeden pracownik, który może się potencjalnie zalogować
	 * oraz zmieniać te uprawnienia.
	 *
	 * Metoda nigdy nie zwraca NULL.
	 */
	public static List<Uprawnienie> uprawnieniaStrategiczne() {
		return Uprawnienie.UPRAWNIENIA_STRATEGICZNE;
	}

	private TypUprawnienia typUprawnienia;

	private Uprawnienie(TypUprawnienia typUprawnienia) {
		this.typUprawnienia = typUprawnienia;
	}

	@Override
	public String getOpis() {
		StringBuffer sb = new StringBuffer();
		String pierwszaLiterka = this.name().substring(0, 1).toUpperCase();
		switch(pierwszaLiterka) {
			case "C": sb.append("'dodawanie'"); break;
			case "R": sb.append("'przeglądanie'"); break;
			case "U": sb.append("'aktualizacja'"); break;
			case "D": sb.append("'usuwanie'"); break;
			default: throw new IllegalArgumentException();
		}
		sb.append(" ");
		sb.append(typUprawnienia.getOpis());
		return sb.toString();
	}

	public TypUprawnienia getTypUprawnienia() {
		return typUprawnienia;
	}

	public String getValue() {
		return this.typUprawnienia.getGrupaUprawnien().getPrzedrostek() + this.name();
	}

	@Override
	public String toString() {
		return this.getValue();
	}
}
