package pl.topteam.dps.magazyn.model;

import java.math.BigDecimal;
import java.util.Date;

public interface StanMagazynu {
	/**
	 * @return data stanu magazynu, którą reprezentuje obiekt
	 */
	public Date getData();

	/**
	 * @return data stanu na dzień uwzględnionego przy wyliczaniu
	 */
	public Date getUwzglednionyStanNaDzien();

	/**
	 * @return ilość obiektów w magazynie na dzień podany
	 * 		za pomocą getData. Uwzględnia wszystkie wpisy stanu na dzień,
	 * 		pobrań czy wstawień do magazynu.
	 */
	public BigDecimal getIlosc();

	/**
	 * @return suma pobrań obiektów z magazynu
	 */
	public BigDecimal getIloscPobran();

	/**
	 * @return suma strat obiektów
	 */
	public BigDecimal getIloscStrat();

	/**
	 * @return darowizna leku
	 */
	public BigDecimal getDarowizna();

	/**
	 * @return pożyczki danego leku do magazynu właściciela
	 */
	public BigDecimal getPozyczonoDo();

	/**
	 * @return pożyczki danego leku z magazynu właściciela
	 */
	public BigDecimal getPozyczonoZ();

	/**
	 * @return przekazanie danego leku do magazynu właściciela
	 */
	public BigDecimal getPrzekazanoDo();

	/**
	 * @return przekazanie danego leku z magazynu właściciela
	 */
	public BigDecimal getPrzekazanoZ();

	/**
	 * @return właściciel obiektów w magazynie (może być NULL)
	 */
	public Wlasciciel getWlasciciel();

	/**
	 * @return obiekt przechowywany w magazynie
	 */
	public ObiektMagazynu getObiekt();

	/**
	 * @return sposób obliczania stanu magazynu (o ile został włączony TRACE)
	 */
	public String getTraceLog();
}
