package pl.topteam.dps.model.main;

import net.karneim.pojobuilder.GeneratePojoBuilder;

import org.apache.commons.lang3.StringUtils;

import pl.topteam.utils.wydruki.zmienne.model.ListaZmiennychWydruku;
import pl.topteam.utils.wydruki.zmienne.model.ZmiennaWydruku;

@ListaZmiennychWydruku(
		id = "adres",
		zmienne = {
			@ZmiennaWydruku(nazwa = "fax", opis = "nr faksu"),
			@ZmiennaWydruku(nazwa = "gmina", opis = "gmina"),
			@ZmiennaWydruku(nazwa = "kodPocztowy", opis = "kod pocztowy"),
			@ZmiennaWydruku(nazwa = "sformatowanyKodPocztowy", opis = "kod pocztowy w formacie '99-999'"),
			@ZmiennaWydruku(nazwa = "miejscowosc", opis = "miejscowość"),
			@ZmiennaWydruku(nazwa = "nrDomu", opis = "nr domu"),
			@ZmiennaWydruku(nazwa = "nrLokalu", opis = "nr lokalu"),
			@ZmiennaWydruku(nazwa = "nrDomuNrLokalu", opis = "nr i lokalu w formacie '99 m. 9'"),
			@ZmiennaWydruku(nazwa = "poczta", opis = "poczta"),
			@ZmiennaWydruku(nazwa = "postacDoDruku", opis = "postać adresu do wydruku postacDoDruku[0] - linia 1, postacDoDruku[1] - linia 2"),
			@ZmiennaWydruku(nazwa = "powiat", opis = "powiat"),
			@ZmiennaWydruku(nazwa = "telefon", opis = "telefon"),
			@ZmiennaWydruku(nazwa = "typ.opis", opis = "typ adresu"),
			@ZmiennaWydruku(nazwa = "ulica", opis = "ulica"),
			@ZmiennaWydruku(nazwa = "ulicaNrDomuNrLokalu", opis = "ulica, nr domu, nr lokalu w formacie 'ul. AAAAA 9999 m. 9'"),
			@ZmiennaWydruku(nazwa = "wojewodztwo.nazwa", opis = "województwo")
		}
	)
@GeneratePojoBuilder
public class Adres extends pl.topteam.dps.model.main_gen.Adres {
	private static final long serialVersionUID = -642036797935500017L;

	public String getSformatowanyKodPocztowy() {
		String kodPocztowy = super.getKodPocztowy();

		if ( (kodPocztowy != null && kodPocztowy.trim().contains(" ")) ||
				StringUtils.isEmpty(kodPocztowy) ||
				kodPocztowy.length() < 5 ) {
			return kodPocztowy;
		}

		StringBuffer sb = new StringBuffer();
		sb.append(kodPocztowy.substring(0, 2));
		sb.append("-");
		sb.append(kodPocztowy.substring(2, 5));

		return sb.toString();
	}

	@Override
	public void setKodPocztowy(String kodPocztowy) {
		// jeżeli Polska
		if(StringUtils.equalsIgnoreCase(getPanstwo(), "500")) {
			if(StringUtils.isNotEmpty(kodPocztowy)) {
				super.setKodPocztowy(
						kodPocztowy.replaceAll("\\D", ""));
			} else {
				super.setKodPocztowy(null);
			}
		} else if(StringUtils.isNotEmpty(kodPocztowy)) {
			super.setKodPocztowy(kodPocztowy);
		} else {
			super.setKodPocztowy(null);
		}
	}

	public String getNrDomuNrLokalu() {
    	StringBuffer sb = new StringBuffer();
    	String nrDomu = getNrDomu();
    	String nrLokalu = getNrLokalu();
    	if (StringUtils.isNotEmpty(nrDomu)) {
    		sb.append(nrDomu);
    	}
    	if (StringUtils.isNotEmpty(nrLokalu)) {
    		sb.append(" m. "+nrLokalu);
    	}

    	return sb.toString();
    }

	public String getUlicaNrDomuNrLokalu() {
		StringBuffer sb = new StringBuffer();

    	String ulica = getUlica() == null ? null : "ul. " + getUlica().trim();
    	String miejscowosc = getMiejscowosc();
    	String nrLokalu = getNrLokalu();
    	String nrDomu = getNrDomu();

    	if (StringUtils.isNotEmpty(ulica)) {
    		sb.append(ulica.trim());
    		sb.append(" ");
    		sb.append(getNrDomuNrLokalu());
    	} else if(StringUtils.isNotEmpty(miejscowosc)) {
    		sb.append(miejscowosc.trim());
    		sb.append(" ");
    		sb.append(getNrDomu());
    	} else if(StringUtils.isNotEmpty(nrLokalu)) {
    		sb.append(ulica.trim());
    		sb.append(" ");
    		sb.append(nrDomu);
    	} else {
    		return "";
    	}

    	return sb.toString();
    }

	/**
	 * @return adres w postaci: {"ul. Mroczna 9/11/13(, Warszawa)", "12-345 Warszawa"}
	 */
    public String[] getPostacDoDruku() {
    	String adres[] = {"", ""};

    	String miejscowosc = getMiejscowosc();
    	String kodPocztowy = getSformatowanyKodPocztowy();
    	String poczta = getPoczta();
    	String ulica = getUlica();

    	adres[0] = getUlicaNrDomuNrLokalu();

    	if (kodPocztowy != null) {
    		adres[1] = kodPocztowy;

    		if (StringUtils.isNotEmpty(poczta) &&
    				StringUtils.isNotEmpty(miejscowosc)) {
    			if (StringUtils.equalsIgnoreCase(poczta.trim(), miejscowosc.trim())) {
    				adres[1] += " " + poczta;
    			} else if (!StringUtils.equalsIgnoreCase(poczta.trim(), miejscowosc.trim()) &&
    					(StringUtils.isEmpty(ulica))) {
     				adres[1] += " " + poczta;
     			} else {
    				adres[1] += " " + poczta + ", " + miejscowosc;
    			}
       		} else if(StringUtils.isNotEmpty(poczta) &&
       				StringUtils.isEmpty(miejscowosc)) {
    			adres[1] += " " + poczta;
    		} else if(StringUtils.isNotEmpty(miejscowosc) &&
    				StringUtils.isEmpty(poczta)) {
    			adres[1] += " " + miejscowosc;
    		}
    	}

    	return adres;
    }
}