package pl.topteam.dps.model.main;

import net.karneim.pojobuilder.GeneratePojoBuilder;
import pl.topteam.utils.wydruki.zmienne.model.ListaZmiennychWydruku;
import pl.topteam.utils.wydruki.zmienne.model.ZmiennaWydruku;
import pl.topteam.utils.wydruki.zmienne.model.ZmiennaWydrukuPominPole;

import com.google.common.base.Objects;

@GeneratePojoBuilder
@ListaZmiennychWydruku(
	id = "decyzjaKierujaca",
	zmienne = {
		@ZmiennaWydruku(nazwa = "dataDo", opis = "data ważności decyzji kierujacej"),
		@ZmiennaWydruku(nazwa = "dataWplywu", opis = "data wpływu decyzji"),
		@ZmiennaWydruku(nazwa = "dataWydania", opis = "data wydania decyzji"),
		@ZmiennaWydruku(nazwa = "id", opis = "unikalny identyfikator decyzji w systemie"),
		@ZmiennaWydruku(nazwa = "ktoWydalId", opis = "unikalny identyfikator organu wydającego decyzję (dostępny w słowniku)"),
		@ZmiennaWydruku(nazwa = "nr", opis = "numer decyzji"),
		@ZmiennaWydruku(nazwa = "postanowienieSaduId", opis = "identyfikator orzeczenia sądowego na podstawie, którego wydano decyzję"),
		@ZmiennaWydruku(nazwa = "osobaId", opis = "identyfikator osoby, której dotyczy decyzja"),
		@ZmiennaWydruku(nazwa = "typ", opis = "typ decyzji"),
		@ZmiennaWydruku(nazwa = "wydanaNaZasadach", opis = "zasady wydania decyzji")
	}
)
public class DecyzjaKierujaca extends pl.topteam.dps.model.main_gen.DecyzjaKierujaca {
	private static final long serialVersionUID = -6159746781670225425L;

	/**
	 * Domyślny priorytet jest na 3 (tak żeby w przyszłości była możliwość przesunięcia tej granicy w obie strony
	 * i wartości priorytetów nie były mniejsze od 0)
	 */
	public static final Integer DOMYSLNY_PRIORYTET = 3;

	@ZmiennaWydrukuPominPole
	public Osoba osoba;

	public Osoba getOsoba() {
		return osoba;
	}

	public void setOsoba(Osoba osoba) {
		this.osoba = osoba;
	}

	@Override
	@ZmiennaWydrukuPominPole
	public Integer getPriorytet() {
		return Objects.firstNonNull(super.getPriorytet(), DOMYSLNY_PRIORYTET);
	}
}