package pl.topteam.dps.model.main;

import net.karneim.pojobuilder.GeneratePojoBuilder;
import pl.topteam.utils.wydruki.zmienne.model.ListaZmiennychWydruku;
import pl.topteam.utils.wydruki.zmienne.model.ZmiennaWydruku;
import pl.topteam.utils.wydruki.zmienne.model.ZmiennaWydrukuPominPole;

@GeneratePojoBuilder
@ListaZmiennychWydruku(
	id = "decyzjaOOdplatnosci",
	zmienne = {
		@ZmiennaWydruku(nazwa = "calkowiteZwolnienie", opis = "czy w decyzji zwalniającej zaznaczono dla osoby całkowie zwolnienie"),
		@ZmiennaWydruku(nazwa = "czlonekRodzId", opis = "unikalny identyfikator członka rodziny, którego dotyczy decyzja"),
		@ZmiennaWydruku(nazwa = "dataWydania", opis = "data wydania decyzji"),
		@ZmiennaWydruku(nazwa = "dochodId", opis = "unikalny identyfikator wyliczonego dochodu"),
		@ZmiennaWydruku(nazwa = "id", opis = "unikalny identyfikator decyzji"),
		@ZmiennaWydruku(nazwa = "ktoWydalId", opis = "unikalny identyfikator organu wydającego decyzję (dane organu dostępne są w słowniku)"),
		@ZmiennaWydruku(nazwa = "kwota", opis = "kwota podana na decyzji"),
		@ZmiennaWydruku(nazwa = "kwotaZwolniona", opis = "kwota zwolnienia z alimentacji/odpłatności"),
		@ZmiennaWydruku(nazwa = "mieszkaniecId", opis = "unikalny identyfikator mieszkańca, którego dotyczy decyzja"),
		@ZmiennaWydruku(nazwa = "nr", opis = "numer decyzji"),
		@ZmiennaWydruku(nazwa = "obowiazujeOd", opis = "data od kiedy decyzja obowiązuje"),
		@ZmiennaWydruku(nazwa = "szablonWydrukuId", opis = "unikalny identyfikator szablonu wydruku zastosowanego dla tej decyzji"),
		@ZmiennaWydruku(nazwa = "typ", opis = "typ decyzji"),
		@ZmiennaWydruku(nazwa = "waznaDo", opis = "data ważności")
	}
)
public class DecyzjaOOdplatnosci extends pl.topteam.dps.model.main_gen.DecyzjaOOdplatnosci {
	private static final long serialVersionUID = -6159746781670225425L;

	@ZmiennaWydrukuPominPole
	private Osoba czlonekRodziny;
	@ZmiennaWydrukuPominPole
	private Osoba mieszkaniec;
	@ZmiennaWydrukuPominPole
	private Long decyzjaKierujacaId;

	public Osoba getCzlonekRodziny() {
		return czlonekRodziny;
	}

	public void setCzlonekRodziny(Osoba czlonekRodziny) {
		this.czlonekRodziny = czlonekRodziny;
	}

	public Osoba getMieszkaniec() {
		return mieszkaniec;
	}

	public void setMieszkaniec(Osoba mieszkaniec) {
		this.mieszkaniec = mieszkaniec;
	}

	public Long getDecyzjaKierujacaId() {
		return decyzjaKierujacaId;
	}

	public void setDecyzjaKierujacaId(Long decyzjaKierujacaId) {
		this.decyzjaKierujacaId = decyzjaKierujacaId;
	}
}