package pl.topteam.dps.model.main;

import net.karneim.pojobuilder.GeneratePojoBuilder;

import org.apache.commons.lang3.StringUtils;

import pl.topteam.utils.wydruki.zmienne.model.ListaZmiennychWydruku;
import pl.topteam.utils.wydruki.zmienne.model.ZmiennaWydruku;

@GeneratePojoBuilder
@ListaZmiennychWydruku(
		id = "dowodOsobisty",
		zmienne = {
			@ZmiennaWydruku(nazwa = "dataWaznosci", opis = "data ważności"),
			@ZmiennaWydruku(nazwa = "dataWydania", opis = "data wydania"),
			@ZmiennaWydruku(nazwa = "seriaNr", opis = "seria i nr"),
			@ZmiennaWydruku(nazwa = "wydanyPrzez", id = "slowo", opis = "pole słownikowe - kto wydał dowód")
		}
	)
public class DowodOsobisty extends pl.topteam.dps.model.main_gen.DowodOsobisty {
	private static final long serialVersionUID = -6159746781670225425L;

	private Slowo wydanyPrzez;

	@Override
	public boolean empty() {
		return StringUtils.isEmpty(getSeriaNr());
	}

	public Slowo getWydanyPrzez() {
		return wydanyPrzez;
	}

	public void setWydanyPrzez(Slowo wydanyPrzez) {
		this.wydanyPrzez = wydanyPrzez;
	}
}