package pl.topteam.dps.model.main;


import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import net.karneim.pojobuilder.GeneratePojoBuilder;

import org.apache.commons.lang3.StringUtils;

import pl.topteam.dps.enums.Aktywacja;
import pl.topteam.dps.enums.NumerProfilu;
import pl.topteam.security.password.GenericPassword;
import pl.topteam.utils.wydruki.zmienne.model.ListaZmiennychWydruku;
import pl.topteam.utils.wydruki.zmienne.model.ZmiennaWydruku;
import pl.topteam.utils.wydruki.zmienne.model.ZmiennaWydrukuPominPole;

import com.google.common.collect.Maps;

@GeneratePojoBuilder
@ListaZmiennychWydruku(
	id = "dpsJednostka",
	zmienne = {
		@ZmiennaWydruku(nazwa = "adres", id = "adres", opis = "ogólna liczba miejsc dostępna w DPS"),
		@ZmiennaWydruku(nazwa = "liczbaMiejsc", opis = "ogólna liczba miejsc dostępna w DPS"),
		@ZmiennaWydruku(nazwa = "liczbaMiejscK", opis = "liczba miejsc dla kobiet dostępna w DPS"),
		@ZmiennaWydruku(nazwa = "liczbaMiejscM", opis = "liczba miejsc dla mężczyzn dostępna w DPS"),
		@ZmiennaWydruku(nazwa = "nazwa", opis = "pełna nazwa jednostki DPS"),
		@ZmiennaWydruku(nazwa = "nazwaSkrocona", opis = "nazwa skrócona jednostki"),
		@ZmiennaWydruku(nazwa = "nip", opis = "NIP jednostki"),
		@ZmiennaWydruku(nazwa = "sformatowanyNip", opis = "NIP sformatowany wg wzoru 999-999-99-99"),
		@ZmiennaWydruku(nazwa = "organProwadzacy", opis = "organ prowadzący jednostki"),
		@ZmiennaWydruku(nazwa = "regon", opis = "REGON jednostki"),
		@ZmiennaWydruku(nazwa = "rodzaj", opis = "rodzaj jednostki")
	}
)
public class DpsJednostka extends pl.topteam.dps.model.main_gen.DpsJednostka {
	private static final long serialVersionUID = -6159746781670225425L;

	@ZmiennaWydrukuPominPole
	private String licencjaLogin;
	@ZmiennaWydrukuPominPole
	private GenericPassword licencjaHaslo;
	@ZmiennaWydrukuPominPole
	private String licencjaNumer;
	@ZmiennaWydrukuPominPole
	private String licencjaKlucz;
	@ZmiennaWydrukuPominPole
	private Aktywacja licencjaPakiet;
	private Adres adres;

	private Integer liczbaMiejsc;
	private Integer liczbaMiejscK;
	private Integer liczbaMiejscM;

	@ZmiennaWydrukuPominPole
	private Map<NumerProfilu, DpsJednostkaProfil> profileDzialanosci;

	public Adres getAdres() {
		return adres;
	}

	public void setAdres(Adres adres) {
		this.adres = adres;
	}

	@Override
	public Long getId() {
		return 1L;
	}

	@Override
	public void setId(Long id) {
		super.setId(1L);
	}

	public String getSformatowanyNip() {
		String nip = super.getNip();

		if ( (nip != null && nip.trim().contains(" ")) ||
				StringUtils.isEmpty(nip) ||
				nip.length() < 10 ) {
			return nip;
		}

		StringBuffer sb = new StringBuffer();
		sb.append(nip.substring(0, 3));
		sb.append("-");
		sb.append(nip.substring(3, 6));
		sb.append("-");
		sb.append(nip.substring(6, 8));
		sb.append("-");
		sb.append(nip.substring(8, 10));

		return sb.toString();
	}

	@Override
	public void setNip(String nip) {
		if(StringUtils.isEmpty(nip)) {
			super.setNip(null);
		} else {
			super.setNip(
					nip.replaceAll("\\D", ""));
		}
	}

	@Override
	public String getRegon() {
		String regon = super.getRegon();

		if(StringUtils.isEmpty(regon)) {
			return null;
		}

		return regon.replaceAll("\\D", "");
	}

	@Override
	public void setRegon(String regon) {
		if(StringUtils.isEmpty(regon)) {
			super.setRegon(null);
		} else {
			super.setRegon(
					regon.replaceAll("\\D", ""));
		}
	}

	public String getLicencjaKlucz() {
		return licencjaKlucz;
	}

	public void setLicencjaKlucz(String licencjaKlucz) {
		this.licencjaKlucz = licencjaKlucz;
	}

	public Aktywacja getLicencjaPakiet() {
		return licencjaPakiet;
	}

	public void setLicencjaPakiet(Aktywacja licencjaPakiet) {
		this.licencjaPakiet = licencjaPakiet;
	}

	public Map<NumerProfilu, DpsJednostkaProfil> getProfileDzialanosci() {
		return profileDzialanosci;
	}

	public void setProfileDzialanosci(
			Map<NumerProfilu, DpsJednostkaProfil> profileDzialanosci) {
		this.profileDzialanosci = profileDzialanosci;
	}

	public void setProfileDzialanosci(List<DpsJednostkaProfil> profileDzialanosci) {
		if(profileDzialanosci != null && !profileDzialanosci.isEmpty()) {
			this.profileDzialanosci = new LinkedHashMap<>();
			for(DpsJednostkaProfil profil : profileDzialanosci) {
				this.profileDzialanosci.put(
						profil.getNumer(), profil);
			}
		} else {
			this.profileDzialanosci = Maps.newHashMap();
		}
	}

	public Integer getLiczbaMiejsc() {
		return liczbaMiejsc;
	}

	public void setLiczbaMiejsc(Integer liczbaMiejsc) {
		this.liczbaMiejsc = liczbaMiejsc;
	}

	public Integer getLiczbaMiejscK() {
		return liczbaMiejscK;
	}

	public void setLiczbaMiejscK(Integer liczbaMiejscK) {
		this.liczbaMiejscK = liczbaMiejscK;
	}

	public Integer getLiczbaMiejscM() {
		return liczbaMiejscM;
	}

	public void setLiczbaMiejscM(Integer liczbaMiejscM) {
		this.liczbaMiejscM = liczbaMiejscM;
	}

	public String getLicencjaLogin() {
		return licencjaLogin;
	}

	public void setLicencjaLogin(String licencjaLogin) {
		this.licencjaLogin = licencjaLogin;
	}

	public GenericPassword getLicencjaHaslo() {
		return licencjaHaslo;
	}

	public void setLicencjaHaslo(GenericPassword licencjaHaslo) {
		this.licencjaHaslo = licencjaHaslo;
	}

	public String getLicencjaNumer() {
		return licencjaNumer;
	}

	public void setLicencjaNumer(String licencjaNumer) {
		this.licencjaNumer = licencjaNumer;
	}
}