package pl.topteam.dps.model.main;

import net.karneim.pojobuilder.GeneratePojoBuilder;

import org.apache.commons.lang3.StringUtils;

import pl.topteam.utils.wydruki.zmienne.model.ListaZmiennychWydruku;
import pl.topteam.utils.wydruki.zmienne.model.ZmiennaWydruku;

@GeneratePojoBuilder
@ListaZmiennychWydruku(
		id = "dpsJednostkaPokoj",
		zmienne = {
			@ZmiennaWydruku(nazwa = "id", opis = "unikalny identyfikator pokoju w programie"),
			@ZmiennaWydruku(nazwa = "liczbaMiejsc", opis = "liczba wszystkich miejsc"),
			@ZmiennaWydruku(nazwa = "nr", opis = "numer pokoju"),
			@ZmiennaWydruku(nazwa = "pietro", opis = "piętro")
		}
	)
public class DpsJednostkaPokoj extends pl.topteam.dps.model.main_gen.DpsJednostkaPokoj {
	private static final long serialVersionUID = -6159746781670225425L;

	public String getOpis() {
		StringBuilder sb = new StringBuilder();

		if(StringUtils.isNotEmpty(getNr())) {
			sb.append(getNr());
		}
		sb.append(" (");
		if(StringUtils.isNotEmpty(getBudynek())) {
			sb.append("bud. ");
			sb.append(getBudynek());
			sb.append(", ");
		}
		sb.append(getPietro());
		sb.append(" p.)");

		return sb.toString();
	}
}