package pl.topteam.dps.model.main;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import net.karneim.pojobuilder.GeneratePojoBuilder;

import org.apache.commons.lang3.StringUtils;

import pl.topteam.utils.wydruki.zmienne.model.ListaZmiennychWydruku;
import pl.topteam.utils.wydruki.zmienne.model.ZmiennaWydruku;

import com.google.common.base.Objects;

@GeneratePojoBuilder
@ListaZmiennychWydruku(
		id = "kontoBankowe",
		zmienne = {
			@ZmiennaWydruku(nazwa = "id", opis = "unikalny identyfikator konta w programie"),
			@ZmiennaWydruku(nazwa = "iban", opis = "numer IBAN"),
			@ZmiennaWydruku(nazwa = "plIban", opis = "numer IBAN w formacie międzynarodowym")
		}
	)
public class KontoBankowe extends pl.topteam.dps.model.main_gen.KontoBankowe {
	private static final long serialVersionUID = -6159746781670225425L;

	private static final Pattern DEFAULT_IBAN_PATTERN = Pattern.compile("(\\d{2})(\\d{4})(\\d{4})(\\d{4})(\\d{4})(\\d{4})(\\d{4})");

	private StringBuilder sb;

	private void initializeStringBuilder() {
		if(sb == null) {
			sb = new StringBuilder();
		}
	}

	@Override
	public void setIban(String iban) {
		if(StringUtils.isEmpty(iban)) {
			super.setIban(null);
		} else {
			super.setIban(iban.replaceAll("\\D", ""));
		}
	}

	public String getPLIban() {
		initializeStringBuilder();

		sb.delete(0, sb.length());

		if(StringUtils.isNotEmpty(getIban())) {
			sb.append("PL ");
			Matcher m = DEFAULT_IBAN_PATTERN.matcher(getIban());
			if (m.find()) {
				for (Integer i = 0; i < m.groupCount(); i++) {
					sb.append(" ");
					sb.append(m.group(i+1));
				}
			} else {
				sb.append(getIban());
			}
		}

		return sb.toString();
	}

	@Override
	public Integer getLicznikPrzypisan() {
		return Objects.firstNonNull(super.getLicznikPrzypisan(), 0);
	}

	@Override
	public Integer getLicznikUzycie() {
		return Objects.firstNonNull(super.getLicznikUzycie(), 0);
	}
}