package pl.topteam.dps.model.main;

import java.util.List;

import net.karneim.pojobuilder.GeneratePojoBuilder;

import org.apache.commons.lang3.StringUtils;

import pl.topteam.dps.magazyn.model.ObiektMagazynu;
import pl.topteam.utils.wydruki.zmienne.model.ZmiennaWydrukuPominPole;

@GeneratePojoBuilder
public class Lek extends pl.topteam.dps.model.main_gen.Lek
		implements ObiektMagazynu, pl.topteam.dps.leki.model.Lek {
	private static final long serialVersionUID = -6159746781670225425L;

	private Boolean czyRecepta;
	@ZmiennaWydrukuPominPole
	private List<LekPostac> postaciLeku;

	public Lek() {
		super();
	}

	public Lek(Long id) {
		this();
		setId(id);
	}

	@Override
	public Long getIdLeku() {
		return getId();
	}

	@Override
	public Long getObiektId() {
		return getId();
	}

	public Boolean getCzyRecepta() {
		return czyRecepta;
	}

	public void setCzyRecepta(Boolean czyRecepta) {
		this.czyRecepta = czyRecepta;
	}

	public List<LekPostac> getPostaciLeku() {
		return postaciLeku;
	}

	public void setPostaciLeku(List<LekPostac> postaciLeku) {
		this.postaciLeku = postaciLeku;
	}

	// nie zmieniać opisu chyba, że wiesz co robisz !!! (on jest używany na niektórych formularzach)
	@Override
	public String toString() {
		// import from BazylLekUtils
		Lek lek = this;
		if(StringUtils.isNotEmpty(lek.getPostac()) &&
				lek.getOpakowanieJednostkaPojemnosci() != null) {
			return lek.getNazwa() +
					" (" +
						lek.getPostac() + "; " +
						lek.getOpakowanieJednostkaPojemnosci() + "; " +
						(lek.getDawka() != null ? lek.getDawka() : "") +
					")";
		}

		return lek.getNazwa();
//		return BazylLekiUtils.uniqNazwaLeku(this);
	}
}