package pl.topteam.dps.model.main;

import net.karneim.pojobuilder.GeneratePojoBuilder;
import pl.topteam.dps.magazyn.model.ObiektMagazynu;
import pl.topteam.utils.wydruki.zmienne.model.ZmiennaWydrukuPominPole;

@GeneratePojoBuilder
public class LekPostac extends pl.topteam.dps.model.main_gen.LekPostac
		implements Cloneable, ObiektMagazynu {
	private static final long serialVersionUID = -6159746781670225425L;

	@ZmiennaWydrukuPominPole
	private Lek lek;
	@ZmiennaWydrukuPominPole
	private LekRealizacja lekRealizacja;

	public LekPostac() {
		super();
	}

	public Lek getLek() {
		return lek;
	}

	public void setLek(Lek lek) {
		this.lek = lek;
	}

	@Override
	public Long getId() {
		return getKodBazyl();
	}

	public void setId(Long id) {
		setKodBazyl(id);
	}

	public LekRealizacja getLekRealizacja() {
		return lekRealizacja;
	}

	public void setLekRealizacja(LekRealizacja lekRealizacja) {
		this.lekRealizacja = lekRealizacja;
	}

	/**
	 * Implementuja interfejsu pl.topteam.dps.magazyn.model.ObiektMagazynu gdzie należy
	 * podawać identyfikator leku przechowywany w magazynie (na tej podstawie
	 * obliczane jest jego zużycie)
	 */
	@Override
	public Long getObiektId() {
		return getLekId();
	}

	@Override
	public Object clone() throws CloneNotSupportedException {
		return super.clone();
	}
}