package pl.topteam.dps.model.main;

import net.karneim.pojobuilder.GeneratePojoBuilder;

import org.joda.time.LocalDate;

import pl.topteam.utils.dateTime.DateUtils;
import pl.topteam.utils.wydruki.zmienne.model.ListaZmiennychWydruku;
import pl.topteam.utils.wydruki.zmienne.model.ZmiennaWydruku;
import pl.topteam.utils.wydruki.zmienne.model.ZmiennaWydrukuPominPole;

@GeneratePojoBuilder
@ListaZmiennychWydruku(
	id = "nieobecnosc",
	zmienne = {
		@ZmiennaWydruku(nazwa = "id", opis = "unikalny identyfikator nieobecności w programie"),
		@ZmiennaWydruku(nazwa = "dataOd", opis = "data od kiedy rozpoczęła się nieobecność"),
		@ZmiennaWydruku(nazwa = "dataDo", opis = "data do kiedy trwała nieobecność"),
		@ZmiennaWydruku(nazwa = "liczbaDni", opis = "wyliczona liczba dni nieobecności"),
		@ZmiennaWydruku(nazwa = "liczbaDniZwrot", opis = "liczba dni, za które zwrócono ekwiwalent pieniężny"),
		@ZmiennaWydruku(nazwa = "status", opis = "status nieobecności (m.in. informuje o tym czy została rozliczona w odpłatnościach)"),
		@ZmiennaWydruku(nazwa = "uwagi", opis = "uwagi zapisane do nieobecności")
	}
)
public class Nieobecnosc extends pl.topteam.dps.model.main_gen.Nieobecnosc {
	private static final long serialVersionUID = -6159746781670225425L;

	@ZmiennaWydrukuPominPole
	private Osoba osoba;

	/**
	 * Zwraca prosty opis dla wyświetlenia np. jako label w polach wyboru
	 *
	 * @return
	 */
	public String getLabel() {
		StringBuilder sb = new StringBuilder();

		// data od
		sb.append("od ");
		if(getDataOd() != null) {
			sb.append(DateUtils.DATE_FORMATTER.print(LocalDate.fromDateFields(getDataOd())));
		} else {
			sb.append("---");
		}

		// data do
		sb.append(" do ");
		if(getDataDo() != null) {
			sb.append(DateUtils.DATE_FORMATTER.print(LocalDate.fromDateFields(getDataDo())));
		} else {
			sb.append("---");
		}

		// liczba dni
		sb.append(" [");
		if(getLiczbaDni() != null) {
			sb.append(getLiczbaDni());
		} else {
			sb.append("---");
		}
		sb.append(" dni]");

		return sb.toString();
	}

	public Osoba getOsoba() {
		return osoba;
	}

	public void setOsoba(Osoba osoba) {
		this.osoba = osoba;
	}
}