package pl.topteam.dps.model.main;

import net.karneim.pojobuilder.GeneratePojoBuilder;

import org.apache.commons.lang3.StringUtils;

import pl.topteam.utils.wydruki.zmienne.model.ListaZmiennychWydruku;
import pl.topteam.utils.wydruki.zmienne.model.ZmiennaWydruku;

@GeneratePojoBuilder
@ListaZmiennychWydruku(
		id = "orzeczONiepelnospraw",
		zmienne = {
			@ZmiennaWydruku(nazwa = "dataOrzeczenia", opis = "data wydania orzeczenia"),
			@ZmiennaWydruku(nazwa = "nr", opis = "numer"),
			@ZmiennaWydruku(nazwa = "obowiazujeOd", opis = "data od kiedy obowiązuje"),
			@ZmiennaWydruku(nazwa = "rodzajOrzecznictwa.opis", opis = "rodzaj orzecznictwa"),
			@ZmiennaWydruku(nazwa = "stopienNiepelnosprawnosci", id = "slowo", opis = "stopień niepełnosprawności"),
			@ZmiennaWydruku(nazwa = "uwagi", opis = "uwagi"),
			@ZmiennaWydruku(nazwa = "wazneDo", opis = "data ważności orzeczenia"),
			@ZmiennaWydruku(nazwa = "wydanePrzez", id = "slowo", opis = "organ wydający orzeczenie")
		}
	)
public class OrzeczONiepelnospraw extends pl.topteam.dps.model.main_gen.OrzeczONiepelnospraw {
	private static final long serialVersionUID = -6159746781670225425L;

	private Slowo wydanePrzez;
	private Slowo stopienNiepelnosprawnosci;

	@Override
	public boolean empty() {
		return super.empty()
			&& getOsobaId() == null
			&& StringUtils.isEmpty(getStopienNiepelnospraw())
			&& getDataOrzeczenia() == null;
	}

	public Slowo getWydanePrzez() {
		return wydanePrzez;
	}

	public void setWydanePrzez(Slowo wydanePrzez) {
		this.wydanePrzez = wydanePrzez;
	}

	public Slowo getStopienNiepelnosprawnosci() {
		return stopienNiepelnosprawnosci;
	}

	public void setStopienNiepelnosprawnosci(Slowo stopienNiepelnosprawnosci) {
		this.stopienNiepelnosprawnosci = stopienNiepelnosprawnosci;
	}
}