package pl.topteam.dps.model.main;

import static org.joda.time.Years.yearsBetween;

import java.util.Date;
import java.util.List;

import net.karneim.pojobuilder.GeneratePojoBuilder;

import org.apache.commons.lang3.StringUtils;
import org.joda.time.LocalDate;

import pl.topteam.dps.enums.MieszkaniecInfo;
import pl.topteam.dps.enums.Plec;
import pl.topteam.dps.magazyn.model.Wlasciciel;
import pl.topteam.utils.wydruki.zmienne.model.ListaZmiennychWydruku;
import pl.topteam.utils.wydruki.zmienne.model.ZmiennaWydruku;
import pl.topteam.utils.wydruki.zmienne.model.ZmiennaWydrukuPominPole;

import com.google.common.base.Function;
import com.google.common.base.Objects;

@GeneratePojoBuilder
@ListaZmiennychWydruku(
	id = "osoba",
	zmienne = {
		@ZmiennaWydruku(nazwa = "dataUrodzenia", opis = "data urodzenia"),
		@ZmiennaWydruku(nazwa = "id", opis = "unikalny identyfikator osoby w programie"),
		@ZmiennaWydruku(nazwa = "imie", opis = "imię"),
		@ZmiennaWydruku(nazwa = "imieDrugie", opis = "drugie imię"),
		@ZmiennaWydruku(nazwa = "imieMatki", opis = "imię matki"),
		@ZmiennaWydruku(nazwa = "imieOjca", opis = "imię ojca"),
		@ZmiennaWydruku(nazwa = "imieWspolmalzonka", opis = "imię współmałżonka"),
		@ZmiennaWydruku(nazwa = "miejsceUrodzenia", opis = "miejsce urodzenia"),
		@ZmiennaWydruku(nazwa = "nazwisko", opis = "nazwisko"),
		@ZmiennaWydruku(nazwa = "nazwiskoImie", opis = "nazwisko i imię razem rozdzielone pojedynczą spacją"),
		@ZmiennaWydruku(nazwa = "nazwiskoRodowe", opis = "nazwisko rodowe"),
		@ZmiennaWydruku(nazwa = "nazwiskoRodoweMatki", opis = "nazwisko rodowe matki"),
		@ZmiennaWydruku(nazwa = "nazwiskoWspolmalzonka", opis = "nazwisko współmałżonka"),
		@ZmiennaWydruku(nazwa = "nip", opis = "NIP"),
		@ZmiennaWydruku(nazwa = "pesel", opis = "PESEL"),
		@ZmiennaWydruku(nazwa = "plec", opis = "płeć osoby (dodatkowo .nazwa wypisze pełną nazwę płci)"),
		@ZmiennaWydruku(nazwa = "sformatowanyNip", opis = "NIP sformatowany wg wzoru 999-999-99-99"),
		@ZmiennaWydruku(nazwa = "stanCywilnyId", opis = "unikalny identyfikator stanu cywilnego dostępnego w słowniku"),
		@ZmiennaWydruku(nazwa = "telefonKom", opis = "numer telefonu komórkowego osoby")
	}
)
public class Osoba extends pl.topteam.dps.model.main_gen.Osoba implements Wlasciciel {
	private static final long serialVersionUID = -6159746781670225425L;

	@ZmiennaWydrukuPominPole
	private DecyzjaKierujaca decyzjaKierujaca;
	@ZmiennaWydrukuPominPole
	private Adres adres;
	@ZmiennaWydrukuPominPole
	private DowodOsobisty dowodOs;
	@ZmiennaWydrukuPominPole
	private DecyzjaWygaszajaca decyzjaWygaszajaca;
	@ZmiennaWydrukuPominPole
	private EwidencjaDps ewidencjaDps;
	@ZmiennaWydrukuPominPole
	private DpsJednostkaPokoj dpsJednostkaPokoj;
	@ZmiennaWydrukuPominPole
	private OsobaRodzina osobaRodzina;
	@ZmiennaWydrukuPominPole
	private List<OsobaRodzina> historiaOsoby;
	@ZmiennaWydrukuPominPole
	private PostanowienieSadu postanowienieSadu;
	@ZmiennaWydrukuPominPole
	private OrzeczONiepelnospraw orzeczenieNiepelnosprawnosc;
	@ZmiennaWydrukuPominPole
	private Date data;
	@ZmiennaWydrukuPominPole
	private List<MieszkaniecInfo> informacjeOMieszkancu;
	
	public static final Function<Osoba, Plec> PLEC_OSOBY = new Function<Osoba, Plec>() {
		@Override public Plec apply(Osoba os) {
			return os.getPlec();
		}
	};
	
	public static final Function<Osoba, Integer> WIEK_OSOBY(final LocalDate naDzien) {
		return new Function<Osoba, Integer>() {
			@Override public Integer apply(Osoba os) {
				LocalDate urodzonaDnia = LocalDate.fromDateFields(os.getDataUrodzenia());
				int wiek = yearsBetween(urodzonaDnia, naDzien).getYears();
				return wiek < 0 ? 0 : wiek;
			}
		};
	}

	public String getNazwiskoImie() {
		return (StringUtils.isNotEmpty(this.getNazwisko()) ? this.getNazwisko() : "")
				+ " " + (StringUtils.isNotEmpty(this.getImie()) ? this.getImie() : "");
	}

	public String getSformatowanyNip() {
		String nip = super.getNip();

		if ((nip != null && nip.trim().contains(" "))
				|| StringUtils.isEmpty(nip) || nip.length() < 10 ) {
			return nip;
		}

		StringBuffer sb = new StringBuffer();
		sb.append(nip.substring(0, 3));
		sb.append("-");
		sb.append(nip.substring(3, 6));
		sb.append("-");
		sb.append(nip.substring(6, 8));
		sb.append("-");
		sb.append(nip.substring(8, 10));
		return sb.toString();
	}

	@Override
	public void setNip(String nip) {
		super.setNip(StringUtils.isEmpty(nip) ? null : nip.replaceAll("\\D", ""));
	}
	public EwidencjaDps getEwidencjaDps() {
		return ewidencjaDps;
	}
	public void setEwidencjaDps(EwidencjaDps ewidencjaDps) {
		this.ewidencjaDps = ewidencjaDps;
	}
	public DowodOsobisty getDowodOs() {
		return dowodOs;
	}
	public void setDowodOs(DowodOsobisty dowodOs) {
		this.dowodOs = dowodOs;
	}
	public Adres getAdres() {
		return adres;
	}
	public void setAdres(Adres adres) {
		this.adres = adres;
	}
	public DecyzjaWygaszajaca getDecyzjaWygaszajaca() {
		return decyzjaWygaszajaca;
	}
	public void setDecyzjaWygaszajaca(DecyzjaWygaszajaca decyzjaWygaszajaca) {
		this.decyzjaWygaszajaca = decyzjaWygaszajaca;
	}
	public PostanowienieSadu getPostanowienieSadu() {
		return postanowienieSadu;
	}
	public void setPostanowienieSadu(PostanowienieSadu postanowienieSadu) {
		this.postanowienieSadu = postanowienieSadu;
	}
	public OrzeczONiepelnospraw getOrzeczenieNiepelnosprawnosc() {
		return orzeczenieNiepelnosprawnosc;
	}
	public void setOrzeczenieNiepelnosprawnosc(
			OrzeczONiepelnospraw orzeczenieNiepelnosprawnosc) {
		this.orzeczenieNiepelnosprawnosc = orzeczenieNiepelnosprawnosc;
	}
	public OsobaRodzina getOsobaRodzina() {
		return osobaRodzina;
	}
	public void setOsobaRodzina(OsobaRodzina osobaRodzina) {
		this.osobaRodzina = osobaRodzina;
	}
	public Date getData() {
		return data;
	}
	public void setData(Date data) {
		this.data = data;
	}
	public List<OsobaRodzina> getHistoriaOsoby() {
		return historiaOsoby;
	}
	public void setHistoriaOsoby(List<OsobaRodzina> historiaOsoby) {
		this.historiaOsoby = historiaOsoby;
	}
	public DpsJednostkaPokoj getDpsJednostkaPokoj() {
		return dpsJednostkaPokoj;
	}
	public void setDpsJednostkaPokoj(DpsJednostkaPokoj dpsJednostkaPokoj) {
		this.dpsJednostkaPokoj = dpsJednostkaPokoj;
	}
	public List<MieszkaniecInfo> getInformacjeOMieszkancu() {
		return informacjeOMieszkancu;
	}
	public void setInformacjeOMieszkancu(List<MieszkaniecInfo> informacjeOMieszkancu) {
		this.informacjeOMieszkancu = informacjeOMieszkancu;
	}
	public DecyzjaKierujaca getDecyzjaKierujaca() {
		return decyzjaKierujaca;
	}
	public void setDecyzjaKierujaca(DecyzjaKierujaca decyzjaKierujaca) {
		this.decyzjaKierujaca = decyzjaKierujaca;
	}

	@Override
	public String toString() {
		return Objects.toStringHelper(this)
				.add("nazwisko", getNazwisko()).add("imie", getImie())
				.add("data urodzenia", getDataUrodzenia()).add("PESEL", getPesel())
				.add("plec", getPlec())
				.toString();
	}
}