package pl.topteam.dps.model.main;

import java.util.List;

import net.karneim.pojobuilder.GeneratePojoBuilder;
import pl.topteam.utils.wydruki.zmienne.model.ListaZmiennychWydruku;
import pl.topteam.utils.wydruki.zmienne.model.ZmiennaWydruku;
import pl.topteam.utils.wydruki.zmienne.model.ZmiennaWydrukuPominPole;

@GeneratePojoBuilder
@ListaZmiennychWydruku(
		id = "planWsparciaMieszkanca",
		zmienne = {
			@ZmiennaWydruku(nazwa = "dataOd", opis = "data od kiedy obowiązuje"),
			@ZmiennaWydruku(nazwa = "dataDo", opis = "data do kiedy obowiązuje (istnieje w przypadku gdy aktualizowano ten plan)"),
			@ZmiennaWydruku(nazwa = "dataWaznosci", opis = "data do kiedy ustalono ważność planu"),
			@ZmiennaWydruku(nazwa = "dataZatwierdzenia", opis = "data zatwierdzenia planu"),
			@ZmiennaWydruku(nazwa = "nr", opis = "numer planu"),
			@ZmiennaWydruku(nazwa = "opis", opis = "opis planu")
		}
	)
public class PlanWsparciaMieszkanca extends pl.topteam.dps.model.main_gen.PlanWsparciaMieszkanca {
	private static final long serialVersionUID = -6159746781670225425L;

	@ZmiennaWydrukuPominPole
	private List<PlanWsparciaCzynnosc> listaCzynnosci;

	public List<PlanWsparciaCzynnosc> getListaCzynnosci() {
		return listaCzynnosci;
	}

	public void setListaCzynnosci(List<PlanWsparciaCzynnosc> listaCzynnosci) {
		this.listaCzynnosci = listaCzynnosci;
	}
}