package pl.topteam.dps.model.main;

import java.util.List;

import net.karneim.pojobuilder.GeneratePojoBuilder;

import org.apache.commons.lang3.StringUtils;
import org.joda.time.LocalDate;

import pl.topteam.dps.enums.JednostkaMiary;
import pl.topteam.utils.dateTime.DateUtils;
import pl.topteam.utils.number.NumberUtils;
import pl.topteam.utils.wydruki.zmienne.enums.UzycieZmiennej;
import pl.topteam.utils.wydruki.zmienne.model.ListaZmiennychWydruku;
import pl.topteam.utils.wydruki.zmienne.model.ZmiennaWydruku;
import pl.topteam.utils.wydruki.zmienne.model.ZmiennaWydrukuPominPole;

@GeneratePojoBuilder
@ListaZmiennychWydruku(
		id = "pobieraneSwiadczenie",
		zmienne = {
			@ZmiennaWydruku(nazwa = "dataOd", opis = "data od kiedy obowiązuje"),
			@ZmiennaWydruku(nazwa = "dataDo", opis = "data do kiedy obowiązuje"),
			@ZmiennaWydruku(nazwa = "dataZmiany", opis = "data zmiany świadczenia"),
			@ZmiennaWydruku(nazwa = "dodatki", id = "swiadczenieDodatek", miejsceUzycia = UzycieZmiennej.TYLKO_BLOK, opis = "dodatki do świadczenia"),
			@ZmiennaWydruku(nazwa = "instytucjaDoplacajaca", id = "instytucjaDoplacajaca", opis = "Instytucja wpłacajaca świadczenie"),
			@ZmiennaWydruku(nazwa = "kwota", opis = "kwota świadczenia"),
			@ZmiennaWydruku(nazwa = "nazwa", opis = "nazwa świadczenia"),
			@ZmiennaWydruku(nazwa = "nr", opis = "numer świadczenia"),
			@ZmiennaWydruku(nazwa = "terminWyplaty", id = "slowo", opis = "numer świadczenia")
		}
	)
public class PobieraneSwiadczenie extends pl.topteam.dps.model.main_gen.PobieraneSwiadczenie {

	/**
	 *
	 */
	private static final long serialVersionUID = -6159746781670225425L;

	private String nazwa;

	@ZmiennaWydrukuPominPole
	private Osoba mieszkaniec;
	private TerminWyplaty terminWyplaty;
	private InstytucjaDoplacajaca instytucjaDoplacajaca;
	private List<SwiadczenieDodatek> dodatki;

	public String getNazwa() {
		return nazwa;
	}

	public void setNazwa(String nazwa) {
		this.nazwa = nazwa;
	}

	public Osoba getMieszkaniec() {
		return mieszkaniec;
	}

	public void setMieszkaniec(Osoba mieszkaniec) {
		this.mieszkaniec = mieszkaniec;
	}

	public List<SwiadczenieDodatek> getDodatki() {
		return dodatki;
	}

	public void setDodatki(List<SwiadczenieDodatek> dodatki) {
		this.dodatki = dodatki;
	}

	public TerminWyplaty getTerminWyplaty() {
		return terminWyplaty;
	}

	public void setTerminWyplaty(TerminWyplaty terminWyplaty) {
		this.terminWyplaty = terminWyplaty;
	}

	public InstytucjaDoplacajaca getInstytucjaDoplacajaca() {
		return instytucjaDoplacajaca;
	}

	public void setInstytucjaDoplacajaca(InstytucjaDoplacajaca instytucjaDoplacajaca) {
		this.instytucjaDoplacajaca = instytucjaDoplacajaca;
	}

	// używane m.in przy wprowadzaniu wpłat
	public String getOpis() {
		return new StringBuilder()
			.append(StringUtils.isNotEmpty(nazwa) ? nazwa : "---")
			.append(" (")
				.append(getDataOd() != null ? DateUtils.DATE_FORMATTER.print(LocalDate.fromDateFields(getDataOd())) : "-")
				.append(", ")
				.append(getDataZmiany() != null ?
						DateUtils.DATE_FORMATTER.print(LocalDate.fromDateFields(getDataZmiany())) :
							(getDataDo() != null ? DateUtils.DATE_FORMATTER.print(LocalDate.fromDateFields(getDataDo())) : "-"))
			.append(")")
			.append(" - ")
			.append(NumberUtils.format(getKwota()))
			.append(JednostkaMiary.POLSKI_ZLOTY.getSkrot())
			.toString();
	}

	@Override
	public boolean empty() {
		return super.empty()
			&& getOsobaId() == null
			&& getKodSwiadczeniaId() == null
			&& getKwota() == null;
	}
}