package pl.topteam.dps.model.main;

import java.util.List;
import java.util.Map;

import net.karneim.pojobuilder.GeneratePojoBuilder;
import pl.topteam.security.password.PasswordPreferences;
import pl.topteam.security.password.gen.CharacterGroup;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;

@GeneratePojoBuilder
public class PolitykaBezpieczenstwa
		extends pl.topteam.dps.model.main_gen.PolitykaBezpieczenstwa implements PasswordPreferences {
	private static final long serialVersionUID = -6159746781670225425L;
	
	public static final Integer MIN = 5;
	public static final Integer MAX = 20;

	private List<GrupaZnakow> grupyZnakow;

	public List<GrupaZnakow> getGrupyZnakow() {
		return grupyZnakow;
	}

	public void setGrupyZnakow(List<GrupaZnakow> grupyZnakow) {
		this.grupyZnakow = grupyZnakow;
	}

	@Override
	public Integer min() {
		return Objects.firstNonNull(getMinDlHasla(), MIN);
	}

	@Override
	public Integer max() {
		return Objects.firstNonNull(getMaxDlHasla(), MAX);
	}

	@Override
	public Map<CharacterGroup, Integer> characterGroups() {
		if(grupyZnakow != null) {
			Map<CharacterGroup, Integer> mapaWymagan = Maps.newHashMap();
			for(GrupaZnakow grupa : grupyZnakow) {
				mapaWymagan.put(
						grupa.getGrupaZnakow(), grupa.getMinZnakow());
			}
			
			return mapaWymagan;
		}
		
		return null;
	}

	@Override
	public String customChars() {
		if(grupyZnakow != null) {
			for(GrupaZnakow grupa : grupyZnakow) {
				if(CharacterGroup.CUSTOM.equals(
						grupa.getGrupaZnakow())) {
					return grupa.getZnaki();
				}
			}
		}
		
		return null;
	}

	@Override
	public Boolean getZastosuj() {
		return Objects.firstNonNull(super.getZastosuj(), false);
	}
}