package pl.topteam.dps.model.main;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

import net.karneim.pojobuilder.GeneratePojoBuilder;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.type.Alias;

import pl.topteam.dps.enums.ProstyPrzelacznik;
import pl.topteam.dps.enums.TypParametruPracownika;
import pl.topteam.dps.enums.predicate.TypParametruPracownikaPredicate;
import pl.topteam.utils.wydruki.zmienne.model.ListaZmiennychWydruku;
import pl.topteam.utils.wydruki.zmienne.model.ZmiennaWydruku;
import pl.topteam.utils.wydruki.zmienne.model.ZmiennaWydrukuPominPole;

@Alias("pracownik")
@GeneratePojoBuilder
@ListaZmiennychWydruku(
		id = "pracownik",
		zmienne = {
			@ZmiennaWydruku(nazwa = "imie", opis = "imię"),
			@ZmiennaWydruku(nazwa = "nazwisko", opis = "nazwisko"),
			@ZmiennaWydruku(nazwa = "nazwiskoImie", opis = "nazwisko i imię razem oddzielone spacją"),
			@ZmiennaWydruku(nazwa = "eMail", opis = "adres e-mail"),
			@ZmiennaWydruku(nazwa = "login", opis = "login, który został przypisany do pracownika"),
			@ZmiennaWydruku(nazwa = "telefon", opis = "telefon (o ile ustawiony został indywidualnie dla pracownika)")
		}
	)
public class Pracownik extends pl.topteam.dps.model.main_gen.Pracownik {
	private static final long serialVersionUID = -5356937164218873465L;

	@ZmiennaWydrukuPominPole
	private String stareHaslo;
	@ZmiennaWydrukuPominPole
	private String powtHaslo;
	@ZmiennaWydrukuPominPole
	private Grupa grupa;
	@ZmiennaWydrukuPominPole
	private List<PracownikParametr> listaUstawien;

	@ZmiennaWydrukuPominPole
	private Date passwordExipred;
	@ZmiennaWydrukuPominPole
	private Date passwordHasToBeChanged;

	public Grupa getGrupa() {
		return grupa;
	}

	public void setGrupa(Grupa grupa) {
		this.grupa = grupa;
	}

	public String getNazwiskoImie() {
		return (
			(StringUtils.isNotEmpty(this.getNazwisko()) ? this.getNazwisko() : "") + " " +
			(StringUtils.isNotEmpty(this.getImie()) ? this.getImie() : ""));
	}

	public List<PracownikParametr> getListaUstawien() {
		return listaUstawien;
	}

	public void setListaUstawien(List<PracownikParametr> listaUstawien) {
		this.listaUstawien = listaUstawien;
	}

	public String getPowtHaslo() {
		return powtHaslo;
	}

	public void setPowtHaslo(String powtHaslo) {
		this.powtHaslo = powtHaslo;
	}

	public Date getPasswordExipred() {
		return passwordExipred;
	}

	public void setPasswordExipred(Date passwordExipred) {
		this.passwordExipred = passwordExipred;
	}

	public Date getPasswordHasToBeChanged() {
		return passwordHasToBeChanged;
	}

	public void setPasswordHasToBeChanged(Date passwordHasToBeChanged) {
		this.passwordHasToBeChanged = passwordHasToBeChanged;
	}

	public String getStareHaslo() {
		return stareHaslo;
	}

	public void setStareHaslo(String stareHaslo) {
		this.stareHaslo = stareHaslo;
	}

	/**
	 * @return lista elementów, o których trzeba pracownikowi przypomnieć w odpowiednim momencie
	 */
	@SuppressWarnings("unchecked")
	@ZmiennaWydrukuPominPole
	public Collection<TypParametruPracownika> getListaPrzypomnien() {
		if(getListaUstawien() != null) {
			return CollectionUtils.select(
					getListaUstawien(),
					new TypParametruPracownikaPredicate(
							TypParametruPracownika.TYPY_PRZYPOMNIEN));
		}

		return new ArrayList<>();
	}

	/**
	 * @return czy pracownik dopuszcza możliwość pożyczania leków przez mieszkańców
	 */
	@ZmiennaWydrukuPominPole
	public Boolean getCzyPozyczkaLekow() {
		if(getListaUstawien() != null) {
			for(PracownikParametr parametr : getListaUstawien()) {
				if(TypParametruPracownika.UMOWZLIW_POZYCZKA_LEKOW.equals(
						parametr.getTyp())) {
					return StringUtils.isNotEmpty(
								parametr.getWartoscS()) &&
							StringUtils.equalsIgnoreCase(
									ProstyPrzelacznik.TAK.name(), parametr.getWartoscS());
				}
			}
		}

		return Boolean.FALSE;
	}

	/**
	 * @return czy pracownik dopuszcza możliwość cofania poprzez przyciski nawigacji w przeglądarce
	 */
	@ZmiennaWydrukuPominPole
	public Boolean getCzyPowrotBackspace() {
		if(getListaUstawien() != null) {
			for(PracownikParametr parametr : getListaUstawien()) {
				if(TypParametruPracownika.UMOWZLIW_POWROT_BACKSPACE.equals(
						parametr.getTyp())) {
					return StringUtils.isNotEmpty(
								parametr.getWartoscS()) &&
							StringUtils.equalsIgnoreCase(
									ProstyPrzelacznik.TAK.name(), parametr.getWartoscS());
				}
			}
		}

		return Boolean.FALSE;
	}

	/**
	 * @return czy pracownik chce by wyróżniać kolorem link do listy przypomnień
	 */
	@ZmiennaWydrukuPominPole
	public Boolean getCzyWyrozniajPrzypomnienia() {
		if(getListaUstawien() != null) {
			for(PracownikParametr parametr : getListaUstawien()) {
				if(TypParametruPracownika.WYROZNIAJ_PRZYPOMNIENIA.equals(
						parametr.getTyp())) {
					return StringUtils.isNotEmpty(
								parametr.getWartoscS()) &&
							StringUtils.equalsIgnoreCase(
									ProstyPrzelacznik.TAK.name(), parametr.getWartoscS());
				}
			}
		}

		return Boolean.FALSE;
	}
}