package pl.topteam.dps.model.main;

import net.karneim.pojobuilder.GeneratePojoBuilder;
import pl.topteam.utils.wydruki.zmienne.model.ListaZmiennychWydruku;
import pl.topteam.utils.wydruki.zmienne.model.ZmiennaWydruku;

@GeneratePojoBuilder
@ListaZmiennychWydruku(
		id = "swiadczenieZwrot",
		zmienne = {
			@ZmiennaWydruku(nazwa = "instytucja", opis = "instytucja do której ma nastąpić/nastąpił zwrot świadczenia"),
			@ZmiennaWydruku(nazwa = "kwota", opis = "kwota zwrotu"),
			@ZmiennaWydruku(nazwa = "mieszkaniec", opis = "mieszkaniec, któremu wypłacano świadczenie"),
			@ZmiennaWydruku(nazwa = "swiadczenie", opis = "wypłacane świadczenie"),
			@ZmiennaWydruku(nazwa = "zwrotId", opis = "czy zwrócono/zarejestrowano zwrot")
		}
	)
public class SwiadczenieZwrot extends pl.topteam.dps.model.main_gen.SwiadczenieZwrot {

	private static final long serialVersionUID = 1L;

	private Long mieszkaniecId;
	private Long osobaId;

	private Osoba mieszkaniec;
	private InstytucjaDoplacajaca instytucja;

	private OdpisZwrot zwrot;
	private PobieraneSwiadczenie swiadczenie;

	public InstytucjaDoplacajaca getInstytucja() {
		return instytucja;
	}
	public void setInstytucja(InstytucjaDoplacajaca instytucja) {
		this.instytucja = instytucja;
	}
	public OdpisZwrot getZwrot() {
		return zwrot;
	}
	public void setZwrot(OdpisZwrot zwrot) {
		this.zwrot = zwrot;
	}
	public PobieraneSwiadczenie getSwiadczenie() {
		return swiadczenie;
	}
	public void setSwiadczenie(PobieraneSwiadczenie swiadczenie) {
		this.swiadczenie = swiadczenie;
	}
	public Osoba getMieszkaniec() {
		return mieszkaniec;
	}
	public void setMieszkaniec(Osoba mieszkaniec) {
		this.mieszkaniec = mieszkaniec;
	}
	public Long getMieszkaniecId() {
		return mieszkaniecId;
	}
	public void setMieszkaniecId(Long mieszkaniecId) {
		this.mieszkaniecId = mieszkaniecId;
	}
	public Long getOsobaId() {
		return osobaId;
	}
	public void setOsobaId(Long osobaId) {
		this.osobaId = osobaId;
	}
}