package pl.topteam.dps.model.main;

import java.io.ObjectStreamException;
import java.io.Serializable;

import net.karneim.pojobuilder.GeneratePojoBuilder;
import net.sf.jooreports.opendocument.BlokDanych;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@GeneratePojoBuilder
public class SzablonBlokFtl extends pl.topteam.dps.model.main_gen.SzablonBlokFtl implements BlokDanych {
	private static final long serialVersionUID = 9007144850853325076L;

	transient private Long id;
	transient private Long szablonWydrukuId;
	transient private SzablonWydruku szablonWydruku;
	
	public SzablonBlokFtl() {}
	
	@Override
	public Long getId() {
		return id;
	}

	@Override
	public void setId(Long id) {
		this.id = id;
	}

	@Override
	public Long getSzablonWydrukuId() {
		return szablonWydrukuId;
	}

	@Override
	public void setSzablonWydrukuId(Long szablonWydrukuId) {
		this.szablonWydrukuId = szablonWydrukuId;
	}

	public SzablonWydruku getSzablonWydruku() {
		return szablonWydruku;
	}

	public void setSzablonWydruku(SzablonWydruku szablonWydruku) {
		this.szablonWydruku = szablonWydruku;
	}
	
	@Override
	public boolean equals(Object obj) {
		if (this == obj) return true;
		if (obj == null) return false;
		if (!(obj instanceof SzablonBlokFtl)) return false;
		
		final SzablonBlokFtl tmp = (SzablonBlokFtl)obj;
		
		return new EqualsBuilder().append(this.getNumerPorzadkowy(), tmp.getNumerPorzadkowy())
			.append(this.getBlok(), tmp.getBlok())
			.append(this.getSzablonWydrukuId(), tmp.getSzablonWydrukuId())
			.isEquals();
	}
	
	@Override
	public int hashCode() {
		return new HashCodeBuilder().append(this.getNumerPorzadkowy())
			.append(this.getBlok()).append(this.getSzablonWydrukuId()).toHashCode();
	}
	
	// implementacja wzorca Dynamic Serialization Proxy
	Object writeReplace() throws ObjectStreamException {
        return new SzablonBlokFtlSerializationProxy(this);
    }

	public static class SzablonBlokFtlSerializationProxy implements Serializable {
		private static final long serialVersionUID = 6332623839681994468L;

		private Integer numerPorzadkowy;
		private String blok;

		public SzablonBlokFtlSerializationProxy(SzablonBlokFtl szablonBlokFtl) {
			this.numerPorzadkowy = szablonBlokFtl.getNumerPorzadkowy();
			this.blok = szablonBlokFtl.getBlok();
		}
		
		Object readResolve() throws ObjectStreamException {
			SzablonBlokFtl szablonBlokFtl = new SzablonBlokFtl();
			
			szablonBlokFtl.setNumerPorzadkowy(this.numerPorzadkowy);
			szablonBlokFtl.setBlok(this.blok);
			
			return szablonBlokFtl;
        }
	}
}