package pl.topteam.dps.model.main;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;

import net.karneim.pojobuilder.GeneratePojoBuilder;
import net.sf.jooreports.opendocument.BlokDanych;
import net.sourceforge.stripes.action.FileBean;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

import pl.topteam.dps.enums.TypSzablonuWydruku;
import pl.topteam.dps.enums.TypWzorca;

@GeneratePojoBuilder
public class SzablonWydruku extends pl.topteam.dps.model.main_gen.SzablonWydruku {
	private static final long serialVersionUID = -7157039567465688387L;
	
	transient private Long id;
	transient private List<SzablonBlokFtl> blokiFtl;
	
	private String ooSzablonName;
	transient private FileBean ooSzablon;
	private String tresc;
	
	/**
	 * Metoda zamienia w tresci wszystkie zmienne które wskazują na to 
	 * że ma zostać podstawiony pod nie blok ftl, na treść tego bloku
	 * np. w treści szablonu wydruku znajduje się tekst #blok1# 
	 * metoda zamienia ta zmienną na treść bloku o numerze porządkowym: 1
	 * 
	 * @return przetworzona treść szablonu wydruku
	 */
	public String getTrescZBlokamiFtl() {
		String trescTmp = getTresc();
		if(StringUtils.isNotEmpty(trescTmp) &&
				getBlokiFtl() != null) {
			for (SzablonBlokFtl tmp : getBlokiFtl()) {
				trescTmp = trescTmp.replaceAll("#blok" + tmp.getNumerPorzadkowy() + "#",
						Matcher.quoteReplacement(tmp.getBlok()));
			}
		}

		return trescTmp;
	}

	@Override
	public Long getId() {
		return this.id;
	}

	@Override
	public void setId(Long id) {
		this.id = id;
	}

	public List<SzablonBlokFtl> getBlokiFtl() {
		return blokiFtl;
	}
	
	public List<BlokDanych> getBlokiDanych() {
		List<BlokDanych> tmpList = new ArrayList<>();
		if(getBlokiFtl() != null) {
			for(SzablonBlokFtl blokFtl : getBlokiFtl()) {
				tmpList.add(blokFtl);
			}
		}
		return tmpList;
	}

	public void setBlokiFtl(List<SzablonBlokFtl> blokiFtl) {
		this.blokiFtl = blokiFtl;
	}

	public String getTresc() {
		return tresc;
	}

	public void setTresc(String tresc) {
		this.tresc = tresc;
	}

	public FileBean getOoSzablon() {
		return ooSzablon;
	}

	public void setOoSzablon(FileBean ooSzablon) {
		this.ooSzablon = ooSzablon;
	}

	public String getOoSzablonName() {
		return ooSzablonName;
	}

	public void setOoSzablonName(String ooSzablonName) {
		this.ooSzablonName = ooSzablonName;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) return true;
		if (obj == null) return false;
		if (!(obj instanceof SzablonWydruku)) return false;
		
		final SzablonWydruku tmp = (SzablonWydruku)obj;
		return new EqualsBuilder().append(this.getNazwa(), tmp.getNazwa())
			.append(this.getTresc(), tmp.getTresc())
			.append(this.getTypWzorca(), tmp.getTypWzorca())
			.isEquals();
	}
	
	@Override
	public int hashCode() {
		return new HashCodeBuilder().append(this.getNazwa())
			.append(this.getTresc()).append(this.getTypWzorca())
			.toHashCode();
	}
	
	// implementacja wzorca Dynamic Serialization Proxy
	Object writeReplace() throws ObjectStreamException {
        return new SzablonWydrukuSerializationProxy(this);
    }
	
	public static class SzablonWydrukuSerializationProxy implements Serializable {
		private static final long serialVersionUID = 5000102035405750159L;

		private String nazwa;
		private String tresc;
		private TypWzorca typWzorca;
		private TypSzablonuWydruku typSzablonu;
		private List<SzablonBlokFtl> blokiFtl;
		
		public SzablonWydrukuSerializationProxy() { 
		}
		
		public SzablonWydrukuSerializationProxy(SzablonWydruku szablonWydruku) {
			this.nazwa = szablonWydruku.getNazwa();
			this.tresc = szablonWydruku.getTresc();
			this.typWzorca = szablonWydruku.getTypWzorca();
			this.typSzablonu = szablonWydruku.getTypSzablonu();
			
			this.blokiFtl = szablonWydruku.getBlokiFtl();
		}
		
		Object readResolve() throws ObjectStreamException {
            SzablonWydruku szablonWydruku = new SzablonWydruku();
            
            szablonWydruku.setNazwa(this.nazwa);
            szablonWydruku.setTresc(this.tresc);
            szablonWydruku.setTypWzorca(this.typWzorca);
            szablonWydruku.setTypSzablonu(this.typSzablonu);

            if(this.blokiFtl != null) {
            	szablonWydruku.setBlokiFtl(this.blokiFtl);
            }
            
            return szablonWydruku;
        }
	}
}