package pl.topteam.dps.model.main;

import java.math.BigDecimal;

import net.karneim.pojobuilder.GeneratePojoBuilder;
import pl.topteam.dps.enums.RodzajZadluzenia;
import pl.topteam.utils.wydruki.zmienne.model.ZmiennaWydrukuPominPole;

@GeneratePojoBuilder
public class WplataSkladnik extends pl.topteam.dps.model.main_gen.WplataSkladnik {

	private static final long serialVersionUID = -889757142536179355L;
	
	private Integer rok;
	private Integer miesiac;
	
	private Long mieszkaniecId;
	private Long osobaId;
	private Long instytucjaId;
	
	private RodzajZadluzenia rodzajZadluzenia;
	private Faktura faktura;
	
	// dane podmiotów, na rzecz których nastąpują/iły wpłaty
	private Osoba osobaDluznik;
	private InstytucjaDoplacajaca instytucjaDluznik;
	
	// kwoty zadłużeń
	private BigDecimal kwotaDlugCalosc;
	private BigDecimal kwotaDlugPobyt;
	
	// kwoty spłacane
	private BigDecimal kwotaPobyt;
	
	@ZmiennaWydrukuPominPole
	@Override
	public Long getId() {
		return Long.valueOf(hashCode());
	}
	
	public Integer getRok() {
		return rok;
	}

	public void setRok(Integer rok) {
		this.rok = rok;
	}

	public Faktura getFaktura() {
		return faktura;
	}

	public void setFaktura(Faktura faktura) {
		this.faktura = faktura;
	}

	public Integer getMiesiac() {
		return miesiac;
	}

	public void setMiesiac(Integer miesiac) {
		this.miesiac = miesiac;
	}

	public Long getOsobaId() {
		return osobaId;
	}

	public void setOsobaId(Long osobaId) {
		this.osobaId = osobaId;
	}

	public Long getMieszkaniecId() {
		return mieszkaniecId;
	}

	public void setMieszkaniecId(Long mieszkaniecId) {
		this.mieszkaniecId = mieszkaniecId;
	}

	public RodzajZadluzenia getRodzajZadluzenia() {
		return rodzajZadluzenia;
	}

	public void setRodzajZadluzenia(RodzajZadluzenia rodzajZadluzenia) {
		this.rodzajZadluzenia = rodzajZadluzenia;
	}

	public BigDecimal getKwotaDlugCalosc() {
		return kwotaDlugCalosc;
	}

	public void setKwotaDlugCalosc(BigDecimal kwotaDlugCalosc) {
		this.kwotaDlugCalosc = kwotaDlugCalosc;
	}

	public BigDecimal getKwotaDlugPobyt() {
		return kwotaDlugPobyt;
	}

	public void setKwotaDlugPobyt(BigDecimal kwotaDlugPobyt) {
		this.kwotaDlugPobyt = kwotaDlugPobyt;
	}

	public BigDecimal getKwotaPobyt() {
		return kwotaPobyt;
	}

	public void setKwotaPobyt(BigDecimal kwotaPobyt) {
		this.kwotaPobyt = kwotaPobyt;
	}

	public Osoba getOsobaDluznik() {
		return osobaDluznik;
	}

	public void setOsobaDluznik(Osoba osobaDluznik) {
		this.osobaDluznik = osobaDluznik;
	}

	public InstytucjaDoplacajaca getInstytucjaDluznik() {
		return instytucjaDluznik;
	}

	public void setInstytucjaDluznik(InstytucjaDoplacajaca instytucjaDluznik) {
		this.instytucjaDluznik = instytucjaDluznik;
	}

	public Long getInstytucjaId() {
		return instytucjaId;
	}

	public void setInstytucjaId(Long instytucjaId) {
		this.instytucjaId = instytucjaId;
	}
}