package pl.topteam.ibatis.reflection.factory;

import static com.google.common.collect.FluentIterable.from;
import static com.google.common.collect.Maps.immutableEntry;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.reflection.factory.DefaultObjectFactory;

import com.google.common.collect.FluentIterable;

public class ExtendedObjectFactory extends DefaultObjectFactory {
	private static final long serialVersionUID = -2119124820392547633L;

	@Override
	@SuppressWarnings("unchecked")
	public <T> T create(Class<T> type, List<Class<?>> constructorArgTypes, List<Object> constructorArgs) {
		Class<?> classToCreate = resolveInterface(type);
		if (classToCreate == Map.Entry.class) {
			return (T) instantiateMapEntry(constructorArgTypes, constructorArgs);
		}
		return super.create(type, constructorArgTypes, constructorArgs);
	}

	private Map.Entry<?, ?> instantiateMapEntry(List<Class<?>> constructorArgTypes, List<Object> constructorArgs) {
		FluentIterable<?> fIterable = from(constructorArgs);
		return immutableEntry(fIterable.first().orNull(), fIterable.skip(1).first().orNull());
	}
}
