package pl.topteam.ibatis.type;

import static pl.topteam.crypt.password.DecryptionUtils.decrypt;
import static pl.topteam.crypt.password.EncryptionUtils.encrypt;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.apache.ibatis.type.TypeException;
import org.apache.ibatis.type.TypeHandler;

import pl.topteam.security.password.GenericPassword;

@MappedJdbcTypes(JdbcType.VARCHAR)
@MappedTypes(value = GenericPassword.class)
public class GenericPasswordTypeHandler implements TypeHandler<GenericPassword> {
	@Override
	public void setParameter(PreparedStatement ps, int i, GenericPassword parameter, JdbcType jdbcType) throws SQLException {
		if (parameter == null) {
			if (jdbcType == null) {
				throw new TypeException("JDBC requires that the JdbcType must be specified for all nullable parameters.");
			}
			ps.setNull(i, jdbcType.TYPE_CODE);
		} else {
			ps.setString(i, encrypt(parameter.getStr()));
		}
	}

	@Override
	public GenericPassword getResult(ResultSet rs, String columnName) throws SQLException {
		return getResult(rs.getString(columnName));
	}

	@Override
	public GenericPassword getResult(ResultSet rs, int columnIndex) throws SQLException {
		return getResult(rs.getString(columnIndex));
	}

	@Override
	public GenericPassword getResult(CallableStatement cs, int columnIndex) throws SQLException {
		return getResult(cs.getString(columnIndex));
	}

	private static GenericPassword getResult(String value) throws SQLException {
		if(StringUtils.isEmpty(value)) {
			return null;
		}
		return new GenericPassword(decrypt(value));
	}
}