package pl.topteam.utils.number;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public final class Formats {
	private Formats() {}

	/**
	 * Konstruuje DecimalFormat według zadanego wzorca i symboli właściwych dla zadanej lokalizacji.
	 * Tryb zaokrąglania formatu zostaje ustawiony na RoundingMode.UNNECESSARY.
	 *
	 * @param pattern - wzorzec formatu
	 * @param locale - lokalizacja
	 *
	 */
	public static DecimalFormat newStrictDecimalFormat(String pattern, Locale locale) {
		DecimalFormat decimalFormat = new DecimalFormat(pattern);
		decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(locale));
		decimalFormat.setRoundingMode(RoundingMode.UNNECESSARY);
		return decimalFormat;
	}
}
