package pl.topteam.utils.wydruki.zmienne.model;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Kontener wszystkich zmiennych wydruku dla danej klasy.
 */
@Inherited
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface ListaZmiennychWydruku {
	/**
	 * Identyfikator grupy zmiennych
	 */
	String id();
	
	/**
	 * Zmienne wydruku odpowiadające polom klasy.
	 */
	ZmiennaWydruku[] zmienne();
}
