package pl.topteam.utils.wydruki.zmienne.model;

import pl.topteam.utils.wydruki.zmienne.enums.UzycieZmiennej;

/**
 * Grupa zmiennych z danej klasy modelu, która jest udostępniana
 * przez daną klasę akcji generującą wydruk.
 */
public @interface ZmiennaUdostepniana {
	/**
	 * Nazwa pod jaką udostępniono obiekt klasy modelu
	 * reprezentujący zmienną wydruku. Obiekt ten posiada własne pola
	 * oraz metody, które stanowią dalsze zmienne względem tej udostępnianej.
	 * 
	 * Np. w klasie wydruku udostępniamy obiekt typu {@link pl.topteam.dps.model.main.Osoba} pod
	 * nazwą "mieszkaniec" wówczas to:
	 * <ul>
	 * 		<li>nazwaZmiennej = "mieszkaniec"</li>
	 * 		<li>id = "osoba"</li>
	 * </ul>
	 * A na wydruku chcąc wypisać imię mieszkańca użyjemy ${mieszkaniec.imie}
	 */
	String nazwaZmiennej();

	/**
	 * Identyfikator grupy zmiennych udostępnianych pod nazwą "nazwaZmiennej"
	 */
	String id();
	
	/**
	 * Miejsce, w którym można użyć danej zmiennej
	 */
	UzycieZmiennej miejsceUzycia() default UzycieZmiennej.SZABLON_I_BLOK;

	/**
	 * Opis zmiennych udostępnianych jako grupa.
	 */
	String opis() default "";
}
