package pl.topteam.utils.wydruki.zmienne.model;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import pl.topteam.utils.wydruki.zmienne.enums.UzycieZmiennej;

/**
 * Zmienna wydruku odpowiadająca polu (bądź metodzie getter) z danej
 * klasy modelu.
 */
@Inherited
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
public @interface ZmiennaWydruku {
	/**
	 * Nazwa zmiennej, pod którą ukryte są dane do wydruku
	 */
	String nazwa();
	
	/**
	 * Odniesienie do klasy modelu
	 */
	String id() default "";
	
	/**
	 * Miejsce, w którym można użyć danej zmiennej
	 */
	UzycieZmiennej miejsceUzycia() default UzycieZmiennej.SZABLON_I_BLOK;
	
	/**
	 * Opis zmiennej
	 */
	String opis() default "";
}
