/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.dps.model.main;

import org.apache.commons.lang3.StringUtils;
import pl.topteam.utils.wydruki.zmienne.model.ListaZmiennychWydruku;
import pl.topteam.utils.wydruki.zmienne.model.ZmiennaWydruku;

@ListaZmiennychWydruku(id="adres", zmienne={@ZmiennaWydruku(nazwa="fax", opis="nr faksu"), @ZmiennaWydruku(nazwa="gmina", opis="gmina"), @ZmiennaWydruku(nazwa="kodPocztowy", opis="kod pocztowy"), @ZmiennaWydruku(nazwa="sformatowanyKodPocztowy", opis="kod pocztowy w formacie '99-999'"), @ZmiennaWydruku(nazwa="miejscowosc", opis="miejscowo\u015b\u0107"), @ZmiennaWydruku(nazwa="nrDomu", opis="nr domu"), @ZmiennaWydruku(nazwa="nrLokalu", opis="nr lokalu"), @ZmiennaWydruku(nazwa="nrDomuNrLokalu", opis="nr i lokalu w formacie '99 m. 9'"), @ZmiennaWydruku(nazwa="poczta", opis="poczta"), @ZmiennaWydruku(nazwa="postacDoDruku", opis="posta\u0107 adresu do wydruku postacDoDruku[0] - linia 1, postacDoDruku[1] - linia 2"), @ZmiennaWydruku(nazwa="powiat", opis="powiat"), @ZmiennaWydruku(nazwa="telefon", opis="telefon"), @ZmiennaWydruku(nazwa="typ.opis", opis="typ adresu"), @ZmiennaWydruku(nazwa="ulica", opis="ulica"), @ZmiennaWydruku(nazwa="ulicaNrDomuNrLokalu", opis="ulica, nr domu, nr lokalu w formacie 'ul. AAAAA 9999 m. 9'"), @ZmiennaWydruku(nazwa="wojewodztwo.nazwa", opis="wojew\u00f3dztwo")})
public class Adres
extends pl.topteam.dps.model.main_gen.Adres {
    private static final long serialVersionUID = -642036797935500017L;

    public String getSformatowanyKodPocztowy() {
        String kodPocztowy = super.getKodPocztowy();
        if (kodPocztowy != null && kodPocztowy.trim().contains(" ") || StringUtils.isEmpty((CharSequence)kodPocztowy) || kodPocztowy.length() < 5) {
            return kodPocztowy;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(kodPocztowy.substring(0, 2));
        sb.append("-");
        sb.append(kodPocztowy.substring(2, 5));
        return sb.toString();
    }

    @Override
    public void setKodPocztowy(String kodPocztowy) {
        if (StringUtils.equalsIgnoreCase((CharSequence)this.getPanstwo(), (CharSequence)"500")) {
            if (StringUtils.isNotEmpty((CharSequence)kodPocztowy)) {
                super.setKodPocztowy(kodPocztowy.replaceAll("\\D", ""));
            } else {
                super.setKodPocztowy(null);
            }
        } else if (StringUtils.isNotEmpty((CharSequence)kodPocztowy)) {
            super.setKodPocztowy(kodPocztowy);
        } else {
            super.setKodPocztowy(null);
        }
    }

    public String getNrDomuNrLokalu() {
        StringBuffer sb = new StringBuffer();
        String nrDomu = this.getNrDomu();
        String nrLokalu = this.getNrLokalu();
        if (StringUtils.isNotEmpty((CharSequence)nrDomu)) {
            sb.append(nrDomu);
        }
        if (StringUtils.isNotEmpty((CharSequence)nrLokalu)) {
            sb.append(" m. " + nrLokalu);
        }
        return sb.toString();
    }

    public String getUlicaNrDomuNrLokalu() {
        StringBuffer sb = new StringBuffer();
        String ulica = this.getUlica() == null ? null : "ul. " + this.getUlica().trim();
        String miejscowosc = this.getMiejscowosc();
        String nrLokalu = this.getNrLokalu();
        String nrDomu = this.getNrDomu();
        if (StringUtils.isNotEmpty((CharSequence)ulica)) {
            sb.append(ulica.trim());
            sb.append(" ");
            sb.append(this.getNrDomuNrLokalu());
        } else if (StringUtils.isNotEmpty((CharSequence)miejscowosc)) {
            sb.append(miejscowosc.trim());
            sb.append(" ");
            sb.append(this.getNrDomu());
        } else if (StringUtils.isNotEmpty((CharSequence)nrLokalu)) {
            sb.append(ulica.trim());
            sb.append(" ");
            sb.append(nrDomu);
        } else {
            return "";
        }
        return sb.toString();
    }

    public String[] getPostacDoDruku() {
        String[] adres = new String[]{"", ""};
        String miejscowosc = this.getMiejscowosc();
        String kodPocztowy = this.getSformatowanyKodPocztowy();
        String poczta = this.getPoczta();
        String ulica = this.getUlica();
        adres[0] = this.getUlicaNrDomuNrLokalu();
        if (kodPocztowy != null) {
            adres[1] = kodPocztowy;
            if (StringUtils.isNotEmpty((CharSequence)poczta) && StringUtils.isNotEmpty((CharSequence)miejscowosc)) {
                adres[1] = StringUtils.equalsIgnoreCase((CharSequence)poczta.trim(), (CharSequence)miejscowosc.trim()) ? adres[1] + " " + poczta : (!StringUtils.equalsIgnoreCase((CharSequence)poczta.trim(), (CharSequence)miejscowosc.trim()) && StringUtils.isEmpty((CharSequence)ulica) ? adres[1] + " " + poczta : adres[1] + " " + poczta + ", " + miejscowosc);
            } else if (StringUtils.isNotEmpty((CharSequence)poczta) && StringUtils.isEmpty((CharSequence)miejscowosc)) {
                adres[1] = adres[1] + " " + poczta;
            } else if (StringUtils.isNotEmpty((CharSequence)miejscowosc) && StringUtils.isEmpty((CharSequence)poczta)) {
                adres[1] = adres[1] + " " + miejscowosc;
            }
        }
        return adres;
    }
}

