/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.dps.model.main;

import com.google.common.base.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import pl.topteam.utils.wydruki.zmienne.model.ListaZmiennychWydruku;
import pl.topteam.utils.wydruki.zmienne.model.ZmiennaWydruku;

@ListaZmiennychWydruku(id="kontoBankowe", zmienne={@ZmiennaWydruku(nazwa="id", opis="unikalny identyfikator konta w programie"), @ZmiennaWydruku(nazwa="iban", opis="numer IBAN"), @ZmiennaWydruku(nazwa="plIban", opis="numer IBAN w formacie mi\u0119dzynarodowym")})
public class KontoBankowe
extends pl.topteam.dps.model.main_gen.KontoBankowe {
    private static final long serialVersionUID = -6159746781670225425L;
    private static final Pattern DEFAULT_IBAN_PATTERN = Pattern.compile("(\\d{2})(\\d{4})(\\d{4})(\\d{4})(\\d{4})(\\d{4})(\\d{4})");
    private StringBuilder sb;

    private void initializeStringBuilder() {
        if (this.sb == null) {
            this.sb = new StringBuilder();
        }
    }

    @Override
    public void setIban(String iban) {
        if (StringUtils.isEmpty((CharSequence)iban)) {
            super.setIban(null);
        } else {
            super.setIban(iban.replaceAll("\\D", ""));
        }
    }

    public String getPLIban() {
        this.initializeStringBuilder();
        this.sb.delete(0, this.sb.length());
        if (StringUtils.isNotEmpty((CharSequence)this.getIban())) {
            this.sb.append("PL ");
            Matcher m = DEFAULT_IBAN_PATTERN.matcher(this.getIban());
            if (m.find()) {
                Integer i = 0;
                while (i < m.groupCount()) {
                    this.sb.append(" ");
                    this.sb.append(m.group(i + 1));
                    Integer n = i;
                    Integer n2 = i = Integer.valueOf(i + 1);
                }
            } else {
                this.sb.append(this.getIban());
            }
        }
        return this.sb.toString();
    }

    @Override
    public Integer getLicznikPrzypisan() {
        return (Integer)Objects.firstNonNull((Object)super.getLicznikPrzypisan(), (Object)0);
    }

    @Override
    public Integer getLicznikUzycie() {
        return (Integer)Objects.firstNonNull((Object)super.getLicznikUzycie(), (Object)0);
    }
}

