/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.ibatis.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.apache.ibatis.type.TypeException;
import org.apache.ibatis.type.TypeHandler;
import pl.topteam.crypt.password.DecryptionUtils;
import pl.topteam.crypt.password.EncryptionUtils;
import pl.topteam.security.password.GenericPassword;

@MappedJdbcTypes(value={JdbcType.VARCHAR})
@MappedTypes(value={GenericPassword.class})
public class GenericPasswordTypeHandler
implements TypeHandler<GenericPassword> {
    public void setParameter(PreparedStatement ps, int i, GenericPassword parameter, JdbcType jdbcType) throws SQLException {
        if (parameter == null) {
            if (jdbcType == null) {
                throw new TypeException("JDBC requires that the JdbcType must be specified for all nullable parameters.");
            }
            ps.setNull(i, jdbcType.TYPE_CODE);
        } else {
            ps.setString(i, EncryptionUtils.encrypt((String)parameter.getStr()));
        }
    }

    public GenericPassword getResult(ResultSet rs, String columnName) throws SQLException {
        return GenericPasswordTypeHandler.getResult(rs.getString(columnName));
    }

    public GenericPassword getResult(ResultSet rs, int columnIndex) throws SQLException {
        return GenericPasswordTypeHandler.getResult(rs.getString(columnIndex));
    }

    public GenericPassword getResult(CallableStatement cs, int columnIndex) throws SQLException {
        return GenericPasswordTypeHandler.getResult(cs.getString(columnIndex));
    }

    private static GenericPassword getResult(String value) throws SQLException {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        return new GenericPassword(DecryptionUtils.decrypt((String)value));
    }
}

