package pl.topteam.dps.dao.main_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.dps.model.main.DawkaLek;
import pl.topteam.dps.model.main.DawkaLekCriteria;
import pl.topteam.dps.model.main_gen.DawkaLekKey;

public abstract interface DawkaLekMapper {
    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @SelectProvider(type=DawkaLekSqlProvider.class, method="countByExample")
    int countByExample(DawkaLekCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @DeleteProvider(type=DawkaLekSqlProvider.class, method="deleteByExample")
    int deleteByExample(DawkaLekCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @Delete({
        "delete from DAWKA_LEK",
        "where DAWKOWANIE_ID = #{dawkowanieId,jdbcType=BIGINT}",
          "and PORA_ID = #{poraId,jdbcType=BIGINT}",
          "and LEK_ID = #{lekId,jdbcType=BIGINT}"
    })
    int deleteByPrimaryKey(DawkaLekKey key);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @Insert({
        "insert into DAWKA_LEK (DAWKOWANIE_ID, PORA_ID, ",
        "LEK_ID, CZY_RECEPTA, ",
        "DAWKA)",
        "values (#{dawkowanieId,jdbcType=BIGINT}, #{poraId,jdbcType=BIGINT}, ",
        "#{lekId,jdbcType=BIGINT}, #{czyRecepta,jdbcType=BOOLEAN}, ",
        "#{dawka,jdbcType=DECIMAL})"
    })
    int insert(DawkaLek record);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    int mergeInto(DawkaLek record);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @InsertProvider(type=DawkaLekSqlProvider.class, method="insertSelective")
    int insertSelective(DawkaLek record);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @SelectProvider(type=DawkaLekSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="DAWKOWANIE_ID", property="dawkowanieId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="PORA_ID", property="poraId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="LEK_ID", property="lekId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="CZY_RECEPTA", property="czyRecepta", jdbcType=JdbcType.BOOLEAN),
        @Result(column="DAWKA", property="dawka", jdbcType=JdbcType.DECIMAL)
    })
    List<DawkaLek> selectByExampleWithRowbounds(DawkaLekCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @SelectProvider(type=DawkaLekSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="DAWKOWANIE_ID", property="dawkowanieId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="PORA_ID", property="poraId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="LEK_ID", property="lekId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="CZY_RECEPTA", property="czyRecepta", jdbcType=JdbcType.BOOLEAN),
        @Result(column="DAWKA", property="dawka", jdbcType=JdbcType.DECIMAL)
    })
    List<DawkaLek> selectByExample(DawkaLekCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @Select({
        "select",
        "DAWKOWANIE_ID, PORA_ID, LEK_ID, CZY_RECEPTA, DAWKA",
        "from DAWKA_LEK",
        "where DAWKOWANIE_ID = #{dawkowanieId,jdbcType=BIGINT}",
          "and PORA_ID = #{poraId,jdbcType=BIGINT}",
          "and LEK_ID = #{lekId,jdbcType=BIGINT}"
    })
    @Results({
        @Result(column="DAWKOWANIE_ID", property="dawkowanieId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="PORA_ID", property="poraId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="LEK_ID", property="lekId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="CZY_RECEPTA", property="czyRecepta", jdbcType=JdbcType.BOOLEAN),
        @Result(column="DAWKA", property="dawka", jdbcType=JdbcType.DECIMAL)
    })
    DawkaLek selectByPrimaryKey(DawkaLekKey key);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @UpdateProvider(type=DawkaLekSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") DawkaLek record, @Param("example") DawkaLekCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @UpdateProvider(type=DawkaLekSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") DawkaLek record, @Param("example") DawkaLekCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @UpdateProvider(type=DawkaLekSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(DawkaLek record);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @Update({
        "update DAWKA_LEK",
        "set CZY_RECEPTA = #{czyRecepta,jdbcType=BOOLEAN},",
          "DAWKA = #{dawka,jdbcType=DECIMAL}",
        "where DAWKOWANIE_ID = #{dawkowanieId,jdbcType=BIGINT}",
          "and PORA_ID = #{poraId,jdbcType=BIGINT}",
          "and LEK_ID = #{lekId,jdbcType=BIGINT}"
    })
    int updateByPrimaryKey(DawkaLek record);
}