package pl.topteam.dps.dao.main_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.dps.model.main.DecyzjaSwiadczenie;
import pl.topteam.dps.model.main.DecyzjaSwiadczenieCriteria;
import pl.topteam.dps.model.main_gen.DecyzjaSwiadczenieKey;

public abstract interface DecyzjaSwiadczenieMapper {
    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @SelectProvider(type=DecyzjaSwiadczenieSqlProvider.class, method="countByExample")
    int countByExample(DecyzjaSwiadczenieCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @DeleteProvider(type=DecyzjaSwiadczenieSqlProvider.class, method="deleteByExample")
    int deleteByExample(DecyzjaSwiadczenieCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @Delete({
        "delete from DECYZJA_SWIADCZENIE",
        "where DECYZJA_ID = #{decyzjaId,jdbcType=BIGINT}",
          "and SWIADCZENIE_ID = #{swiadczenieId,jdbcType=BIGINT}"
    })
    int deleteByPrimaryKey(DecyzjaSwiadczenieKey key);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @Insert({
        "insert into DECYZJA_SWIADCZENIE (DECYZJA_ID, SWIADCZENIE_ID, ",
        "ILOSC_LIMIT, OKRES_ILOSC_LIMIT, ",
        "OKRES_LIMIT, PROCENT_ODPLATNOSC)",
        "values (#{decyzjaId,jdbcType=BIGINT}, #{swiadczenieId,jdbcType=BIGINT}, ",
        "#{iloscLimit,jdbcType=DECIMAL}, #{okresIloscLimit,jdbcType=DECIMAL}, ",
        "#{okresLimit,jdbcType=VARCHAR}, #{procentOdplatnosc,jdbcType=INTEGER})"
    })
    int insert(DecyzjaSwiadczenie record);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    int mergeInto(DecyzjaSwiadczenie record);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @InsertProvider(type=DecyzjaSwiadczenieSqlProvider.class, method="insertSelective")
    int insertSelective(DecyzjaSwiadczenie record);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @SelectProvider(type=DecyzjaSwiadczenieSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="DECYZJA_ID", property="decyzjaId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="SWIADCZENIE_ID", property="swiadczenieId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="ILOSC_LIMIT", property="iloscLimit", jdbcType=JdbcType.DECIMAL),
        @Result(column="OKRES_ILOSC_LIMIT", property="okresIloscLimit", jdbcType=JdbcType.DECIMAL),
        @Result(column="OKRES_LIMIT", property="okresLimit", jdbcType=JdbcType.VARCHAR),
        @Result(column="PROCENT_ODPLATNOSC", property="procentOdplatnosc", jdbcType=JdbcType.INTEGER)
    })
    List<DecyzjaSwiadczenie> selectByExampleWithRowbounds(DecyzjaSwiadczenieCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @SelectProvider(type=DecyzjaSwiadczenieSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="DECYZJA_ID", property="decyzjaId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="SWIADCZENIE_ID", property="swiadczenieId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="ILOSC_LIMIT", property="iloscLimit", jdbcType=JdbcType.DECIMAL),
        @Result(column="OKRES_ILOSC_LIMIT", property="okresIloscLimit", jdbcType=JdbcType.DECIMAL),
        @Result(column="OKRES_LIMIT", property="okresLimit", jdbcType=JdbcType.VARCHAR),
        @Result(column="PROCENT_ODPLATNOSC", property="procentOdplatnosc", jdbcType=JdbcType.INTEGER)
    })
    List<DecyzjaSwiadczenie> selectByExample(DecyzjaSwiadczenieCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @Select({
        "select",
        "DECYZJA_ID, SWIADCZENIE_ID, ILOSC_LIMIT, OKRES_ILOSC_LIMIT, OKRES_LIMIT, PROCENT_ODPLATNOSC",
        "from DECYZJA_SWIADCZENIE",
        "where DECYZJA_ID = #{decyzjaId,jdbcType=BIGINT}",
          "and SWIADCZENIE_ID = #{swiadczenieId,jdbcType=BIGINT}"
    })
    @Results({
        @Result(column="DECYZJA_ID", property="decyzjaId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="SWIADCZENIE_ID", property="swiadczenieId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="ILOSC_LIMIT", property="iloscLimit", jdbcType=JdbcType.DECIMAL),
        @Result(column="OKRES_ILOSC_LIMIT", property="okresIloscLimit", jdbcType=JdbcType.DECIMAL),
        @Result(column="OKRES_LIMIT", property="okresLimit", jdbcType=JdbcType.VARCHAR),
        @Result(column="PROCENT_ODPLATNOSC", property="procentOdplatnosc", jdbcType=JdbcType.INTEGER)
    })
    DecyzjaSwiadczenie selectByPrimaryKey(DecyzjaSwiadczenieKey key);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @UpdateProvider(type=DecyzjaSwiadczenieSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") DecyzjaSwiadczenie record, @Param("example") DecyzjaSwiadczenieCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @UpdateProvider(type=DecyzjaSwiadczenieSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") DecyzjaSwiadczenie record, @Param("example") DecyzjaSwiadczenieCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @UpdateProvider(type=DecyzjaSwiadczenieSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(DecyzjaSwiadczenie record);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @Update({
        "update DECYZJA_SWIADCZENIE",
        "set ILOSC_LIMIT = #{iloscLimit,jdbcType=DECIMAL},",
          "OKRES_ILOSC_LIMIT = #{okresIloscLimit,jdbcType=DECIMAL},",
          "OKRES_LIMIT = #{okresLimit,jdbcType=VARCHAR},",
          "PROCENT_ODPLATNOSC = #{procentOdplatnosc,jdbcType=INTEGER}",
        "where DECYZJA_ID = #{decyzjaId,jdbcType=BIGINT}",
          "and SWIADCZENIE_ID = #{swiadczenieId,jdbcType=BIGINT}"
    })
    int updateByPrimaryKey(DecyzjaSwiadczenie record);
}