package pl.topteam.dps.dao.main_gen;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import pl.topteam.dps.model.main.DepozytPKonto;
import pl.topteam.dps.model.main_gen.DepozytPKontoCriteria.Criteria;
import pl.topteam.dps.model.main_gen.DepozytPKontoCriteria.Criterion;
import pl.topteam.dps.model.main.DepozytPKontoCriteria;

public class DepozytPKontoSqlProvider {

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String countByExample(DepozytPKontoCriteria example) {
        SQL sql = new SQL();
        sql.SELECT("count(*)").FROM("DEPOZYT_P_KONTO");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String deleteByExample(DepozytPKontoCriteria example) {
        SQL sql = new SQL();
        sql.DELETE_FROM("DEPOZYT_P_KONTO");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String insertSelective(DepozytPKonto record) {
        SQL sql = new SQL();
        sql.INSERT_INTO("DEPOZYT_P_KONTO");
        
        if (record.getKontoBankoweId() != null) {
            sql.VALUES("KONTO_BANKOWE_ID", "#{kontoBankoweId,jdbcType=BIGINT}");
        }
        
        if (record.getOsobaId() != null) {
            sql.VALUES("OSOBA_ID", "#{osobaId,jdbcType=BIGINT}");
        }
        
        if (record.getZamkniete() != null) {
            sql.VALUES("ZAMKNIETE", "#{zamkniete,jdbcType=BOOLEAN}");
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String selectByExample(DepozytPKontoCriteria example) {
        SQL sql = new SQL();
        if (example != null && example.isDistinct()) {
            sql.SELECT_DISTINCT("ID");
        } else {
            sql.SELECT("ID");
        }
        sql.SELECT("KONTO_BANKOWE_ID");
        sql.SELECT("OSOBA_ID");
        sql.SELECT("ZAMKNIETE");
        sql.FROM("DEPOZYT_P_KONTO");
        applyWhere(sql, example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            sql.ORDER_BY(example.getOrderByClause());
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String updateByExampleSelective(Map<String, Object> parameter) {
        DepozytPKonto record = (DepozytPKonto) parameter.get("record");
        DepozytPKontoCriteria example = (DepozytPKontoCriteria) parameter.get("example");
        
        SQL sql = new SQL();
        sql.UPDATE("DEPOZYT_P_KONTO");
        
        if (record.getId() != null) {
            sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        }
        
        if (record.getKontoBankoweId() != null) {
            sql.SET("KONTO_BANKOWE_ID = #{record.kontoBankoweId,jdbcType=BIGINT}");
        }
        
        if (record.getOsobaId() != null) {
            sql.SET("OSOBA_ID = #{record.osobaId,jdbcType=BIGINT}");
        }
        
        if (record.getZamkniete() != null) {
            sql.SET("ZAMKNIETE = #{record.zamkniete,jdbcType=BOOLEAN}");
        }
        
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String updateByExample(Map<String, Object> parameter) {
        SQL sql = new SQL();
        sql.UPDATE("DEPOZYT_P_KONTO");
        
        sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        sql.SET("KONTO_BANKOWE_ID = #{record.kontoBankoweId,jdbcType=BIGINT}");
        sql.SET("OSOBA_ID = #{record.osobaId,jdbcType=BIGINT}");
        sql.SET("ZAMKNIETE = #{record.zamkniete,jdbcType=BOOLEAN}");
        
        DepozytPKontoCriteria example = (DepozytPKontoCriteria) parameter.get("example");
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String updateByPrimaryKeySelective(DepozytPKonto record) {
        SQL sql = new SQL();
        sql.UPDATE("DEPOZYT_P_KONTO");
        
        if (record.getKontoBankoweId() != null) {
            sql.SET("KONTO_BANKOWE_ID = #{kontoBankoweId,jdbcType=BIGINT}");
        }
        
        if (record.getOsobaId() != null) {
            sql.SET("OSOBA_ID = #{osobaId,jdbcType=BIGINT}");
        }
        
        if (record.getZamkniete() != null) {
            sql.SET("ZAMKNIETE = #{zamkniete,jdbcType=BOOLEAN}");
        }
        
        sql.WHERE("ID = #{id,jdbcType=BIGINT}");
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    protected void applyWhere(SQL sql, DepozytPKontoCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            sql.WHERE(sb.toString());
        }
    }
}