package pl.topteam.dps.dao.main_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.dps.model.main.DochodSwiadczenieSkladnik;
import pl.topteam.dps.model.main.DochodSwiadczenieSkladnikCriteria;
import pl.topteam.dps.model.main_gen.DochodSwiadczenieSkladnikKey;

public abstract interface DochodSwiadczenieSkladnikMapper {
    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @SelectProvider(type=DochodSwiadczenieSkladnikSqlProvider.class, method="countByExample")
    int countByExample(DochodSwiadczenieSkladnikCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @DeleteProvider(type=DochodSwiadczenieSkladnikSqlProvider.class, method="deleteByExample")
    int deleteByExample(DochodSwiadczenieSkladnikCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @Delete({
        "delete from DOCHOD_SWIADCZENIE_SKLADNIK",
        "where DOCHOD_ID = #{dochodId,jdbcType=BIGINT}",
          "and SWIADCZENIE_ID = #{swiadczenieId,jdbcType=BIGINT}"
    })
    int deleteByPrimaryKey(DochodSwiadczenieSkladnikKey key);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @Insert({
        "insert into DOCHOD_SWIADCZENIE_SKLADNIK (DOCHOD_ID, SWIADCZENIE_ID)",
        "values (#{dochodId,jdbcType=BIGINT}, #{swiadczenieId,jdbcType=BIGINT})"
    })
    int insert(DochodSwiadczenieSkladnik record);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    int mergeInto(DochodSwiadczenieSkladnik record);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @InsertProvider(type=DochodSwiadczenieSkladnikSqlProvider.class, method="insertSelective")
    int insertSelective(DochodSwiadczenieSkladnik record);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @SelectProvider(type=DochodSwiadczenieSkladnikSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="DOCHOD_ID", property="dochodId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="SWIADCZENIE_ID", property="swiadczenieId", jdbcType=JdbcType.BIGINT, id=true)
    })
    List<DochodSwiadczenieSkladnik> selectByExampleWithRowbounds(DochodSwiadczenieSkladnikCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @SelectProvider(type=DochodSwiadczenieSkladnikSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="DOCHOD_ID", property="dochodId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="SWIADCZENIE_ID", property="swiadczenieId", jdbcType=JdbcType.BIGINT, id=true)
    })
    List<DochodSwiadczenieSkladnik> selectByExample(DochodSwiadczenieSkladnikCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @UpdateProvider(type=DochodSwiadczenieSkladnikSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") DochodSwiadczenieSkladnik record, @Param("example") DochodSwiadczenieSkladnikCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @UpdateProvider(type=DochodSwiadczenieSkladnikSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") DochodSwiadczenieSkladnik record, @Param("example") DochodSwiadczenieSkladnikCriteria example);
}