package pl.topteam.dps.dao.main_gen;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import pl.topteam.dps.model.main.DpsJednostkaPokoj;
import pl.topteam.dps.model.main_gen.DpsJednostkaPokojCriteria.Criteria;
import pl.topteam.dps.model.main_gen.DpsJednostkaPokojCriteria.Criterion;
import pl.topteam.dps.model.main.DpsJednostkaPokojCriteria;

public class DpsJednostkaPokojSqlProvider {

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String countByExample(DpsJednostkaPokojCriteria example) {
        SQL sql = new SQL();
        sql.SELECT("count(*)").FROM("DPS_JEDNOSTKA_POKOJ");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String deleteByExample(DpsJednostkaPokojCriteria example) {
        SQL sql = new SQL();
        sql.DELETE_FROM("DPS_JEDNOSTKA_POKOJ");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String insertSelective(DpsJednostkaPokoj record) {
        SQL sql = new SQL();
        sql.INSERT_INTO("DPS_JEDNOSTKA_POKOJ");
        
        if (record.getDpsJednostkaId() != null) {
            sql.VALUES("DPS_JEDNOSTKA_ID", "#{dpsJednostkaId,jdbcType=BIGINT}");
        }
        
        if (record.getBudynek() != null) {
            sql.VALUES("BUDYNEK", "#{budynek,jdbcType=VARCHAR}");
        }
        
        if (record.getLiczbaMiejsc() != null) {
            sql.VALUES("LICZBA_MIEJSC", "#{liczbaMiejsc,jdbcType=INTEGER}");
        }
        
        if (record.getNr() != null) {
            sql.VALUES("NR", "#{nr,jdbcType=VARCHAR}");
        }
        
        if (record.getPietro() != null) {
            sql.VALUES("PIETRO", "#{pietro,jdbcType=INTEGER}");
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String selectByExample(DpsJednostkaPokojCriteria example) {
        SQL sql = new SQL();
        if (example != null && example.isDistinct()) {
            sql.SELECT_DISTINCT("ID");
        } else {
            sql.SELECT("ID");
        }
        sql.SELECT("DPS_JEDNOSTKA_ID");
        sql.SELECT("BUDYNEK");
        sql.SELECT("LICZBA_MIEJSC");
        sql.SELECT("NR");
        sql.SELECT("PIETRO");
        sql.FROM("DPS_JEDNOSTKA_POKOJ");
        applyWhere(sql, example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            sql.ORDER_BY(example.getOrderByClause());
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String updateByExampleSelective(Map<String, Object> parameter) {
        DpsJednostkaPokoj record = (DpsJednostkaPokoj) parameter.get("record");
        DpsJednostkaPokojCriteria example = (DpsJednostkaPokojCriteria) parameter.get("example");
        
        SQL sql = new SQL();
        sql.UPDATE("DPS_JEDNOSTKA_POKOJ");
        
        if (record.getId() != null) {
            sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        }
        
        if (record.getDpsJednostkaId() != null) {
            sql.SET("DPS_JEDNOSTKA_ID = #{record.dpsJednostkaId,jdbcType=BIGINT}");
        }
        
        if (record.getBudynek() != null) {
            sql.SET("BUDYNEK = #{record.budynek,jdbcType=VARCHAR}");
        }
        
        if (record.getLiczbaMiejsc() != null) {
            sql.SET("LICZBA_MIEJSC = #{record.liczbaMiejsc,jdbcType=INTEGER}");
        }
        
        if (record.getNr() != null) {
            sql.SET("NR = #{record.nr,jdbcType=VARCHAR}");
        }
        
        if (record.getPietro() != null) {
            sql.SET("PIETRO = #{record.pietro,jdbcType=INTEGER}");
        }
        
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String updateByExample(Map<String, Object> parameter) {
        SQL sql = new SQL();
        sql.UPDATE("DPS_JEDNOSTKA_POKOJ");
        
        sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        sql.SET("DPS_JEDNOSTKA_ID = #{record.dpsJednostkaId,jdbcType=BIGINT}");
        sql.SET("BUDYNEK = #{record.budynek,jdbcType=VARCHAR}");
        sql.SET("LICZBA_MIEJSC = #{record.liczbaMiejsc,jdbcType=INTEGER}");
        sql.SET("NR = #{record.nr,jdbcType=VARCHAR}");
        sql.SET("PIETRO = #{record.pietro,jdbcType=INTEGER}");
        
        DpsJednostkaPokojCriteria example = (DpsJednostkaPokojCriteria) parameter.get("example");
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String updateByPrimaryKeySelective(DpsJednostkaPokoj record) {
        SQL sql = new SQL();
        sql.UPDATE("DPS_JEDNOSTKA_POKOJ");
        
        if (record.getDpsJednostkaId() != null) {
            sql.SET("DPS_JEDNOSTKA_ID = #{dpsJednostkaId,jdbcType=BIGINT}");
        }
        
        if (record.getBudynek() != null) {
            sql.SET("BUDYNEK = #{budynek,jdbcType=VARCHAR}");
        }
        
        if (record.getLiczbaMiejsc() != null) {
            sql.SET("LICZBA_MIEJSC = #{liczbaMiejsc,jdbcType=INTEGER}");
        }
        
        if (record.getNr() != null) {
            sql.SET("NR = #{nr,jdbcType=VARCHAR}");
        }
        
        if (record.getPietro() != null) {
            sql.SET("PIETRO = #{pietro,jdbcType=INTEGER}");
        }
        
        sql.WHERE("ID = #{id,jdbcType=BIGINT}");
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    protected void applyWhere(SQL sql, DpsJednostkaPokojCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            sql.WHERE(sb.toString());
        }
    }
}