package pl.topteam.dps.dao.main_gen;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import pl.topteam.dps.model.main.LekPostac;
import pl.topteam.dps.model.main_gen.LekPostacCriteria.Criteria;
import pl.topteam.dps.model.main_gen.LekPostacCriteria.Criterion;
import pl.topteam.dps.model.main.LekPostacCriteria;

public class LekPostacSqlProvider {

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String countByExample(LekPostacCriteria example) {
        SQL sql = new SQL();
        sql.SELECT("count(*)").FROM("LEK_POSTAC");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String deleteByExample(LekPostacCriteria example) {
        SQL sql = new SQL();
        sql.DELETE_FROM("LEK_POSTAC");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String insertSelective(LekPostac record) {
        SQL sql = new SQL();
        sql.INSERT_INTO("LEK_POSTAC");
        
        if (record.getKodBazyl() != null) {
            sql.VALUES("KOD_BAZYL", "#{kodBazyl,jdbcType=BIGINT}");
        }
        
        if (record.getLekId() != null) {
            sql.VALUES("LEK_ID", "#{lekId,jdbcType=BIGINT}");
        }
        
        if (record.getDopObrotPolska() != null) {
            sql.VALUES("DOP_OBROT_POLSKA", "#{dopObrotPolska,jdbcType=BOOLEAN}");
        }
        
        if (record.getOpakowanieIlosc() != null) {
            sql.VALUES("OPAKOWANIE_ILOSC", "#{opakowanieIlosc,jdbcType=DECIMAL}");
        }
        
        if (record.getOpakowanieOpisBazyl() != null) {
            sql.VALUES("OPAKOWANIE_OPIS_BAZYL", "#{opakowanieOpisBazyl,jdbcType=VARCHAR}");
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String selectByExample(LekPostacCriteria example) {
        SQL sql = new SQL();
        if (example != null && example.isDistinct()) {
            sql.SELECT_DISTINCT("KOD_BAZYL");
        } else {
            sql.SELECT("KOD_BAZYL");
        }
        sql.SELECT("LEK_ID");
        sql.SELECT("DOP_OBROT_POLSKA");
        sql.SELECT("OPAKOWANIE_ILOSC");
        sql.SELECT("OPAKOWANIE_OPIS_BAZYL");
        sql.FROM("LEK_POSTAC");
        applyWhere(sql, example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            sql.ORDER_BY(example.getOrderByClause());
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String updateByExampleSelective(Map<String, Object> parameter) {
        LekPostac record = (LekPostac) parameter.get("record");
        LekPostacCriteria example = (LekPostacCriteria) parameter.get("example");
        
        SQL sql = new SQL();
        sql.UPDATE("LEK_POSTAC");
        
        if (record.getKodBazyl() != null) {
            sql.SET("KOD_BAZYL = #{record.kodBazyl,jdbcType=BIGINT}");
        }
        
        if (record.getLekId() != null) {
            sql.SET("LEK_ID = #{record.lekId,jdbcType=BIGINT}");
        }
        
        if (record.getDopObrotPolska() != null) {
            sql.SET("DOP_OBROT_POLSKA = #{record.dopObrotPolska,jdbcType=BOOLEAN}");
        }
        
        if (record.getOpakowanieIlosc() != null) {
            sql.SET("OPAKOWANIE_ILOSC = #{record.opakowanieIlosc,jdbcType=DECIMAL}");
        }
        
        if (record.getOpakowanieOpisBazyl() != null) {
            sql.SET("OPAKOWANIE_OPIS_BAZYL = #{record.opakowanieOpisBazyl,jdbcType=VARCHAR}");
        }
        
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String updateByExample(Map<String, Object> parameter) {
        SQL sql = new SQL();
        sql.UPDATE("LEK_POSTAC");
        
        sql.SET("KOD_BAZYL = #{record.kodBazyl,jdbcType=BIGINT}");
        sql.SET("LEK_ID = #{record.lekId,jdbcType=BIGINT}");
        sql.SET("DOP_OBROT_POLSKA = #{record.dopObrotPolska,jdbcType=BOOLEAN}");
        sql.SET("OPAKOWANIE_ILOSC = #{record.opakowanieIlosc,jdbcType=DECIMAL}");
        sql.SET("OPAKOWANIE_OPIS_BAZYL = #{record.opakowanieOpisBazyl,jdbcType=VARCHAR}");
        
        LekPostacCriteria example = (LekPostacCriteria) parameter.get("example");
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String updateByPrimaryKeySelective(LekPostac record) {
        SQL sql = new SQL();
        sql.UPDATE("LEK_POSTAC");
        
        if (record.getLekId() != null) {
            sql.SET("LEK_ID = #{lekId,jdbcType=BIGINT}");
        }
        
        if (record.getDopObrotPolska() != null) {
            sql.SET("DOP_OBROT_POLSKA = #{dopObrotPolska,jdbcType=BOOLEAN}");
        }
        
        if (record.getOpakowanieIlosc() != null) {
            sql.SET("OPAKOWANIE_ILOSC = #{opakowanieIlosc,jdbcType=DECIMAL}");
        }
        
        if (record.getOpakowanieOpisBazyl() != null) {
            sql.SET("OPAKOWANIE_OPIS_BAZYL = #{opakowanieOpisBazyl,jdbcType=VARCHAR}");
        }
        
        sql.WHERE("KOD_BAZYL = #{kodBazyl,jdbcType=BIGINT}");
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    protected void applyWhere(SQL sql, LekPostacCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            sql.WHERE(sb.toString());
        }
    }
}