package pl.topteam.dps.dao.main_gen;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import pl.topteam.dps.model.main.OsobaPracownik;
import pl.topteam.dps.model.main_gen.OsobaPracownikCriteria.Criteria;
import pl.topteam.dps.model.main_gen.OsobaPracownikCriteria.Criterion;
import pl.topteam.dps.model.main.OsobaPracownikCriteria;

public class OsobaPracownikSqlProvider {

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String countByExample(OsobaPracownikCriteria example) {
        SQL sql = new SQL();
        sql.SELECT("count(*)").FROM("OSOBA_PRACOWNIK");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String deleteByExample(OsobaPracownikCriteria example) {
        SQL sql = new SQL();
        sql.DELETE_FROM("OSOBA_PRACOWNIK");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String insertSelective(OsobaPracownik record) {
        SQL sql = new SQL();
        sql.INSERT_INTO("OSOBA_PRACOWNIK");
        
        if (record.getOsobaId() != null) {
            sql.VALUES("OSOBA_ID", "#{osobaId,jdbcType=BIGINT}");
        }
        
        if (record.getPracownikId() != null) {
            sql.VALUES("PRACOWNIK_ID", "#{pracownikId,jdbcType=BIGINT}");
        }
        
        if (record.getPracownikPrzypisalId() != null) {
            sql.VALUES("PRACOWNIK_PRZYPISAL_ID", "#{pracownikPrzypisalId,jdbcType=BIGINT}");
        }
        
        if (record.getPracownikZmienilId() != null) {
            sql.VALUES("PRACOWNIK_ZMIENIL_ID", "#{pracownikZmienilId,jdbcType=BIGINT}");
        }
        
        if (record.getDataPrzypisania() != null) {
            sql.VALUES("DATA_PRZYPISANIA", "#{dataPrzypisania,jdbcType=TIMESTAMP}");
        }
        
        if (record.getDataZmiany() != null) {
            sql.VALUES("DATA_ZMIANY", "#{dataZmiany,jdbcType=TIMESTAMP}");
        }
        
        if (record.getTypPracownika() != null) {
            sql.VALUES("TYP_PRACOWNIKA", "#{typPracownika,jdbcType=VARCHAR}");
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String selectByExample(OsobaPracownikCriteria example) {
        SQL sql = new SQL();
        if (example != null && example.isDistinct()) {
            sql.SELECT_DISTINCT("ID");
        } else {
            sql.SELECT("ID");
        }
        sql.SELECT("OSOBA_ID");
        sql.SELECT("PRACOWNIK_ID");
        sql.SELECT("PRACOWNIK_PRZYPISAL_ID");
        sql.SELECT("PRACOWNIK_ZMIENIL_ID");
        sql.SELECT("DATA_PRZYPISANIA");
        sql.SELECT("DATA_ZMIANY");
        sql.SELECT("TYP_PRACOWNIKA");
        sql.FROM("OSOBA_PRACOWNIK");
        applyWhere(sql, example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            sql.ORDER_BY(example.getOrderByClause());
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String updateByExampleSelective(Map<String, Object> parameter) {
        OsobaPracownik record = (OsobaPracownik) parameter.get("record");
        OsobaPracownikCriteria example = (OsobaPracownikCriteria) parameter.get("example");
        
        SQL sql = new SQL();
        sql.UPDATE("OSOBA_PRACOWNIK");
        
        if (record.getId() != null) {
            sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        }
        
        if (record.getOsobaId() != null) {
            sql.SET("OSOBA_ID = #{record.osobaId,jdbcType=BIGINT}");
        }
        
        if (record.getPracownikId() != null) {
            sql.SET("PRACOWNIK_ID = #{record.pracownikId,jdbcType=BIGINT}");
        }
        
        if (record.getPracownikPrzypisalId() != null) {
            sql.SET("PRACOWNIK_PRZYPISAL_ID = #{record.pracownikPrzypisalId,jdbcType=BIGINT}");
        }
        
        if (record.getPracownikZmienilId() != null) {
            sql.SET("PRACOWNIK_ZMIENIL_ID = #{record.pracownikZmienilId,jdbcType=BIGINT}");
        }
        
        if (record.getDataPrzypisania() != null) {
            sql.SET("DATA_PRZYPISANIA = #{record.dataPrzypisania,jdbcType=TIMESTAMP}");
        }
        
        if (record.getDataZmiany() != null) {
            sql.SET("DATA_ZMIANY = #{record.dataZmiany,jdbcType=TIMESTAMP}");
        }
        
        if (record.getTypPracownika() != null) {
            sql.SET("TYP_PRACOWNIKA = #{record.typPracownika,jdbcType=VARCHAR}");
        }
        
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String updateByExample(Map<String, Object> parameter) {
        SQL sql = new SQL();
        sql.UPDATE("OSOBA_PRACOWNIK");
        
        sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        sql.SET("OSOBA_ID = #{record.osobaId,jdbcType=BIGINT}");
        sql.SET("PRACOWNIK_ID = #{record.pracownikId,jdbcType=BIGINT}");
        sql.SET("PRACOWNIK_PRZYPISAL_ID = #{record.pracownikPrzypisalId,jdbcType=BIGINT}");
        sql.SET("PRACOWNIK_ZMIENIL_ID = #{record.pracownikZmienilId,jdbcType=BIGINT}");
        sql.SET("DATA_PRZYPISANIA = #{record.dataPrzypisania,jdbcType=TIMESTAMP}");
        sql.SET("DATA_ZMIANY = #{record.dataZmiany,jdbcType=TIMESTAMP}");
        sql.SET("TYP_PRACOWNIKA = #{record.typPracownika,jdbcType=VARCHAR}");
        
        OsobaPracownikCriteria example = (OsobaPracownikCriteria) parameter.get("example");
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String updateByPrimaryKeySelective(OsobaPracownik record) {
        SQL sql = new SQL();
        sql.UPDATE("OSOBA_PRACOWNIK");
        
        if (record.getOsobaId() != null) {
            sql.SET("OSOBA_ID = #{osobaId,jdbcType=BIGINT}");
        }
        
        if (record.getPracownikId() != null) {
            sql.SET("PRACOWNIK_ID = #{pracownikId,jdbcType=BIGINT}");
        }
        
        if (record.getPracownikPrzypisalId() != null) {
            sql.SET("PRACOWNIK_PRZYPISAL_ID = #{pracownikPrzypisalId,jdbcType=BIGINT}");
        }
        
        if (record.getPracownikZmienilId() != null) {
            sql.SET("PRACOWNIK_ZMIENIL_ID = #{pracownikZmienilId,jdbcType=BIGINT}");
        }
        
        if (record.getDataPrzypisania() != null) {
            sql.SET("DATA_PRZYPISANIA = #{dataPrzypisania,jdbcType=TIMESTAMP}");
        }
        
        if (record.getDataZmiany() != null) {
            sql.SET("DATA_ZMIANY = #{dataZmiany,jdbcType=TIMESTAMP}");
        }
        
        if (record.getTypPracownika() != null) {
            sql.SET("TYP_PRACOWNIKA = #{typPracownika,jdbcType=VARCHAR}");
        }
        
        sql.WHERE("ID = #{id,jdbcType=BIGINT}");
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    protected void applyWhere(SQL sql, OsobaPracownikCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            sql.WHERE(sb.toString());
        }
    }
}