package pl.topteam.dps.dao.main_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectKey;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.dps.model.main.Pracownik;
import pl.topteam.dps.model.main.PracownikCriteria;

public abstract interface PracownikMapper {
    /**
     * @mbggenerated 2014-03-17 12:09:35
     */
    @SelectProvider(type=PracownikSqlProvider.class, method="countByExample")
    int countByExample(PracownikCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:35
     */
    @DeleteProvider(type=PracownikSqlProvider.class, method="deleteByExample")
    int deleteByExample(PracownikCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:35
     */
    @Delete({
        "delete from PRACOWNIK",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int deleteByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-17 12:09:35
     */
    @Insert({
        "insert into PRACOWNIK (GRUPA_ID, CZY_PRACUJE, ",
        "DATA_OSTATNIEGO_LOGOWANIA, DATA_ZMIANY_HASLA, ",
        "E_MAIL, LOGIN, HASLO, ",
        "IMIE, LICZBA_N_LOGOWAN, ",
        "NAZWISKO, TELEFON, ",
        "ZABLOKOWANE)",
        "values (#{grupaId,jdbcType=BIGINT}, #{czyPracuje,jdbcType=SMALLINT}, ",
        "#{dataOstatniegoLogowania,jdbcType=TIMESTAMP}, #{dataZmianyHasla,jdbcType=DATE}, ",
        "#{eMail,jdbcType=VARCHAR}, #{login,jdbcType=VARCHAR}, #{haslo,jdbcType=VARCHAR}, ",
        "#{imie,jdbcType=VARCHAR}, #{liczbaNLogowan,jdbcType=INTEGER}, ",
        "#{nazwisko,jdbcType=VARCHAR}, #{telefon,jdbcType=VARCHAR}, ",
        "#{zablokowane,jdbcType=BOOLEAN})"
    })
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insert(Pracownik record);

    /**
     * @mbggenerated 2014-03-17 12:09:35
     */
    int mergeInto(Pracownik record);

    /**
     * @mbggenerated 2014-03-17 12:09:35
     */
    @InsertProvider(type=PracownikSqlProvider.class, method="insertSelective")
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insertSelective(Pracownik record);

    /**
     * @mbggenerated 2014-03-17 12:09:35
     */
    @SelectProvider(type=PracownikSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="GRUPA_ID", property="grupaId", jdbcType=JdbcType.BIGINT),
        @Result(column="CZY_PRACUJE", property="czyPracuje", jdbcType=JdbcType.SMALLINT),
        @Result(column="DATA_OSTATNIEGO_LOGOWANIA", property="dataOstatniegoLogowania", jdbcType=JdbcType.TIMESTAMP),
        @Result(column="DATA_ZMIANY_HASLA", property="dataZmianyHasla", jdbcType=JdbcType.DATE),
        @Result(column="E_MAIL", property="eMail", jdbcType=JdbcType.VARCHAR),
        @Result(column="LOGIN", property="login", jdbcType=JdbcType.VARCHAR),
        @Result(column="HASLO", property="haslo", jdbcType=JdbcType.VARCHAR),
        @Result(column="IMIE", property="imie", jdbcType=JdbcType.VARCHAR),
        @Result(column="LICZBA_N_LOGOWAN", property="liczbaNLogowan", jdbcType=JdbcType.INTEGER),
        @Result(column="NAZWISKO", property="nazwisko", jdbcType=JdbcType.VARCHAR),
        @Result(column="TELEFON", property="telefon", jdbcType=JdbcType.VARCHAR),
        @Result(column="ZABLOKOWANE", property="zablokowane", jdbcType=JdbcType.BOOLEAN)
    })
    List<Pracownik> selectByExampleWithRowbounds(PracownikCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2014-03-17 12:09:35
     */
    @SelectProvider(type=PracownikSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="GRUPA_ID", property="grupaId", jdbcType=JdbcType.BIGINT),
        @Result(column="CZY_PRACUJE", property="czyPracuje", jdbcType=JdbcType.SMALLINT),
        @Result(column="DATA_OSTATNIEGO_LOGOWANIA", property="dataOstatniegoLogowania", jdbcType=JdbcType.TIMESTAMP),
        @Result(column="DATA_ZMIANY_HASLA", property="dataZmianyHasla", jdbcType=JdbcType.DATE),
        @Result(column="E_MAIL", property="eMail", jdbcType=JdbcType.VARCHAR),
        @Result(column="LOGIN", property="login", jdbcType=JdbcType.VARCHAR),
        @Result(column="HASLO", property="haslo", jdbcType=JdbcType.VARCHAR),
        @Result(column="IMIE", property="imie", jdbcType=JdbcType.VARCHAR),
        @Result(column="LICZBA_N_LOGOWAN", property="liczbaNLogowan", jdbcType=JdbcType.INTEGER),
        @Result(column="NAZWISKO", property="nazwisko", jdbcType=JdbcType.VARCHAR),
        @Result(column="TELEFON", property="telefon", jdbcType=JdbcType.VARCHAR),
        @Result(column="ZABLOKOWANE", property="zablokowane", jdbcType=JdbcType.BOOLEAN)
    })
    List<Pracownik> selectByExample(PracownikCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:35
     */
    @Select({
        "select",
        "ID, GRUPA_ID, CZY_PRACUJE, DATA_OSTATNIEGO_LOGOWANIA, DATA_ZMIANY_HASLA, E_MAIL, ",
        "LOGIN, HASLO, IMIE, LICZBA_N_LOGOWAN, NAZWISKO, TELEFON, ZABLOKOWANE",
        "from PRACOWNIK",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="GRUPA_ID", property="grupaId", jdbcType=JdbcType.BIGINT),
        @Result(column="CZY_PRACUJE", property="czyPracuje", jdbcType=JdbcType.SMALLINT),
        @Result(column="DATA_OSTATNIEGO_LOGOWANIA", property="dataOstatniegoLogowania", jdbcType=JdbcType.TIMESTAMP),
        @Result(column="DATA_ZMIANY_HASLA", property="dataZmianyHasla", jdbcType=JdbcType.DATE),
        @Result(column="E_MAIL", property="eMail", jdbcType=JdbcType.VARCHAR),
        @Result(column="LOGIN", property="login", jdbcType=JdbcType.VARCHAR),
        @Result(column="HASLO", property="haslo", jdbcType=JdbcType.VARCHAR),
        @Result(column="IMIE", property="imie", jdbcType=JdbcType.VARCHAR),
        @Result(column="LICZBA_N_LOGOWAN", property="liczbaNLogowan", jdbcType=JdbcType.INTEGER),
        @Result(column="NAZWISKO", property="nazwisko", jdbcType=JdbcType.VARCHAR),
        @Result(column="TELEFON", property="telefon", jdbcType=JdbcType.VARCHAR),
        @Result(column="ZABLOKOWANE", property="zablokowane", jdbcType=JdbcType.BOOLEAN)
    })
    Pracownik selectByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-17 12:09:35
     */
    @UpdateProvider(type=PracownikSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") Pracownik record, @Param("example") PracownikCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:35
     */
    @UpdateProvider(type=PracownikSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") Pracownik record, @Param("example") PracownikCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:35
     */
    @UpdateProvider(type=PracownikSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(Pracownik record);

    /**
     * @mbggenerated 2014-03-17 12:09:35
     */
    @Update({
        "update PRACOWNIK",
        "set GRUPA_ID = #{grupaId,jdbcType=BIGINT},",
          "CZY_PRACUJE = #{czyPracuje,jdbcType=SMALLINT},",
          "DATA_OSTATNIEGO_LOGOWANIA = #{dataOstatniegoLogowania,jdbcType=TIMESTAMP},",
          "DATA_ZMIANY_HASLA = #{dataZmianyHasla,jdbcType=DATE},",
          "E_MAIL = #{eMail,jdbcType=VARCHAR},",
          "LOGIN = #{login,jdbcType=VARCHAR},",
          "HASLO = #{haslo,jdbcType=VARCHAR},",
          "IMIE = #{imie,jdbcType=VARCHAR},",
          "LICZBA_N_LOGOWAN = #{liczbaNLogowan,jdbcType=INTEGER},",
          "NAZWISKO = #{nazwisko,jdbcType=VARCHAR},",
          "TELEFON = #{telefon,jdbcType=VARCHAR},",
          "ZABLOKOWANE = #{zablokowane,jdbcType=BOOLEAN}",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int updateByPrimaryKey(Pracownik record);
}