package pl.topteam.dps.dao.main_gen;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import pl.topteam.dps.model.main.QrtzFiredTriggers;
import pl.topteam.dps.model.main_gen.QrtzFiredTriggersCriteria.Criteria;
import pl.topteam.dps.model.main_gen.QrtzFiredTriggersCriteria.Criterion;
import pl.topteam.dps.model.main.QrtzFiredTriggersCriteria;

public class QrtzFiredTriggersSqlProvider {

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String countByExample(QrtzFiredTriggersCriteria example) {
        SQL sql = new SQL();
        sql.SELECT("count(*)").FROM("QRTZ_FIRED_TRIGGERS");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String deleteByExample(QrtzFiredTriggersCriteria example) {
        SQL sql = new SQL();
        sql.DELETE_FROM("QRTZ_FIRED_TRIGGERS");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String insertSelective(QrtzFiredTriggers record) {
        SQL sql = new SQL();
        sql.INSERT_INTO("QRTZ_FIRED_TRIGGERS");
        
        if (record.getSchedName() != null) {
            sql.VALUES("SCHED_NAME", "#{schedName,jdbcType=VARCHAR}");
        }
        
        if (record.getEntryId() != null) {
            sql.VALUES("ENTRY_ID", "#{entryId,jdbcType=VARCHAR}");
        }
        
        if (record.getTriggerName() != null) {
            sql.VALUES("TRIGGER_NAME", "#{triggerName,jdbcType=VARCHAR}");
        }
        
        if (record.getTriggerGroup() != null) {
            sql.VALUES("TRIGGER_GROUP", "#{triggerGroup,jdbcType=VARCHAR}");
        }
        
        if (record.getInstanceName() != null) {
            sql.VALUES("INSTANCE_NAME", "#{instanceName,jdbcType=VARCHAR}");
        }
        
        if (record.getFiredTime() != null) {
            sql.VALUES("FIRED_TIME", "#{firedTime,jdbcType=BIGINT}");
        }
        
        if (record.getPriority() != null) {
            sql.VALUES("PRIORITY", "#{priority,jdbcType=INTEGER}");
        }
        
        if (record.getState() != null) {
            sql.VALUES("STATE", "#{state,jdbcType=VARCHAR}");
        }
        
        if (record.getJobName() != null) {
            sql.VALUES("JOB_NAME", "#{jobName,jdbcType=VARCHAR}");
        }
        
        if (record.getJobGroup() != null) {
            sql.VALUES("JOB_GROUP", "#{jobGroup,jdbcType=VARCHAR}");
        }
        
        if (record.getIsNonconcurrent() != null) {
            sql.VALUES("IS_NONCONCURRENT", "#{isNonconcurrent,jdbcType=BOOLEAN}");
        }
        
        if (record.getRequestsRecovery() != null) {
            sql.VALUES("REQUESTS_RECOVERY", "#{requestsRecovery,jdbcType=BOOLEAN}");
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String selectByExample(QrtzFiredTriggersCriteria example) {
        SQL sql = new SQL();
        if (example != null && example.isDistinct()) {
            sql.SELECT_DISTINCT("SCHED_NAME");
        } else {
            sql.SELECT("SCHED_NAME");
        }
        sql.SELECT("ENTRY_ID");
        sql.SELECT("TRIGGER_NAME");
        sql.SELECT("TRIGGER_GROUP");
        sql.SELECT("INSTANCE_NAME");
        sql.SELECT("FIRED_TIME");
        sql.SELECT("PRIORITY");
        sql.SELECT("STATE");
        sql.SELECT("JOB_NAME");
        sql.SELECT("JOB_GROUP");
        sql.SELECT("IS_NONCONCURRENT");
        sql.SELECT("REQUESTS_RECOVERY");
        sql.FROM("QRTZ_FIRED_TRIGGERS");
        applyWhere(sql, example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            sql.ORDER_BY(example.getOrderByClause());
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String updateByExampleSelective(Map<String, Object> parameter) {
        QrtzFiredTriggers record = (QrtzFiredTriggers) parameter.get("record");
        QrtzFiredTriggersCriteria example = (QrtzFiredTriggersCriteria) parameter.get("example");
        
        SQL sql = new SQL();
        sql.UPDATE("QRTZ_FIRED_TRIGGERS");
        
        if (record.getSchedName() != null) {
            sql.SET("SCHED_NAME = #{record.schedName,jdbcType=VARCHAR}");
        }
        
        if (record.getEntryId() != null) {
            sql.SET("ENTRY_ID = #{record.entryId,jdbcType=VARCHAR}");
        }
        
        if (record.getTriggerName() != null) {
            sql.SET("TRIGGER_NAME = #{record.triggerName,jdbcType=VARCHAR}");
        }
        
        if (record.getTriggerGroup() != null) {
            sql.SET("TRIGGER_GROUP = #{record.triggerGroup,jdbcType=VARCHAR}");
        }
        
        if (record.getInstanceName() != null) {
            sql.SET("INSTANCE_NAME = #{record.instanceName,jdbcType=VARCHAR}");
        }
        
        if (record.getFiredTime() != null) {
            sql.SET("FIRED_TIME = #{record.firedTime,jdbcType=BIGINT}");
        }
        
        if (record.getPriority() != null) {
            sql.SET("PRIORITY = #{record.priority,jdbcType=INTEGER}");
        }
        
        if (record.getState() != null) {
            sql.SET("STATE = #{record.state,jdbcType=VARCHAR}");
        }
        
        if (record.getJobName() != null) {
            sql.SET("JOB_NAME = #{record.jobName,jdbcType=VARCHAR}");
        }
        
        if (record.getJobGroup() != null) {
            sql.SET("JOB_GROUP = #{record.jobGroup,jdbcType=VARCHAR}");
        }
        
        if (record.getIsNonconcurrent() != null) {
            sql.SET("IS_NONCONCURRENT = #{record.isNonconcurrent,jdbcType=BOOLEAN}");
        }
        
        if (record.getRequestsRecovery() != null) {
            sql.SET("REQUESTS_RECOVERY = #{record.requestsRecovery,jdbcType=BOOLEAN}");
        }
        
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String updateByExample(Map<String, Object> parameter) {
        SQL sql = new SQL();
        sql.UPDATE("QRTZ_FIRED_TRIGGERS");
        
        sql.SET("SCHED_NAME = #{record.schedName,jdbcType=VARCHAR}");
        sql.SET("ENTRY_ID = #{record.entryId,jdbcType=VARCHAR}");
        sql.SET("TRIGGER_NAME = #{record.triggerName,jdbcType=VARCHAR}");
        sql.SET("TRIGGER_GROUP = #{record.triggerGroup,jdbcType=VARCHAR}");
        sql.SET("INSTANCE_NAME = #{record.instanceName,jdbcType=VARCHAR}");
        sql.SET("FIRED_TIME = #{record.firedTime,jdbcType=BIGINT}");
        sql.SET("PRIORITY = #{record.priority,jdbcType=INTEGER}");
        sql.SET("STATE = #{record.state,jdbcType=VARCHAR}");
        sql.SET("JOB_NAME = #{record.jobName,jdbcType=VARCHAR}");
        sql.SET("JOB_GROUP = #{record.jobGroup,jdbcType=VARCHAR}");
        sql.SET("IS_NONCONCURRENT = #{record.isNonconcurrent,jdbcType=BOOLEAN}");
        sql.SET("REQUESTS_RECOVERY = #{record.requestsRecovery,jdbcType=BOOLEAN}");
        
        QrtzFiredTriggersCriteria example = (QrtzFiredTriggersCriteria) parameter.get("example");
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String updateByPrimaryKeySelective(QrtzFiredTriggers record) {
        SQL sql = new SQL();
        sql.UPDATE("QRTZ_FIRED_TRIGGERS");
        
        if (record.getTriggerName() != null) {
            sql.SET("TRIGGER_NAME = #{triggerName,jdbcType=VARCHAR}");
        }
        
        if (record.getTriggerGroup() != null) {
            sql.SET("TRIGGER_GROUP = #{triggerGroup,jdbcType=VARCHAR}");
        }
        
        if (record.getInstanceName() != null) {
            sql.SET("INSTANCE_NAME = #{instanceName,jdbcType=VARCHAR}");
        }
        
        if (record.getFiredTime() != null) {
            sql.SET("FIRED_TIME = #{firedTime,jdbcType=BIGINT}");
        }
        
        if (record.getPriority() != null) {
            sql.SET("PRIORITY = #{priority,jdbcType=INTEGER}");
        }
        
        if (record.getState() != null) {
            sql.SET("STATE = #{state,jdbcType=VARCHAR}");
        }
        
        if (record.getJobName() != null) {
            sql.SET("JOB_NAME = #{jobName,jdbcType=VARCHAR}");
        }
        
        if (record.getJobGroup() != null) {
            sql.SET("JOB_GROUP = #{jobGroup,jdbcType=VARCHAR}");
        }
        
        if (record.getIsNonconcurrent() != null) {
            sql.SET("IS_NONCONCURRENT = #{isNonconcurrent,jdbcType=BOOLEAN}");
        }
        
        if (record.getRequestsRecovery() != null) {
            sql.SET("REQUESTS_RECOVERY = #{requestsRecovery,jdbcType=BOOLEAN}");
        }
        
        sql.WHERE("SCHED_NAME = #{schedName,jdbcType=VARCHAR}");
        sql.WHERE("ENTRY_ID = #{entryId,jdbcType=VARCHAR}");
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    protected void applyWhere(SQL sql, QrtzFiredTriggersCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            sql.WHERE(sb.toString());
        }
    }
}