package pl.topteam.dps.dao.main_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.dps.model.main.RealizacjaWrp;
import pl.topteam.dps.model.main.RealizacjaWrpCriteria;

public abstract interface RealizacjaWrpMapper {
    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @SelectProvider(type=RealizacjaWrpSqlProvider.class, method="countByExample")
    int countByExample(RealizacjaWrpCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @DeleteProvider(type=RealizacjaWrpSqlProvider.class, method="deleteByExample")
    int deleteByExample(RealizacjaWrpCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @Delete({
        "delete from REALIZACJA_WRP",
        "where OPERACJA_ID = #{operacjaId,jdbcType=BIGINT}"
    })
    int deleteByPrimaryKey(Long operacjaId);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @Insert({
        "insert into REALIZACJA_WRP (OPERACJA_ID, PORA_DNIA_ID)",
        "values (#{operacjaId,jdbcType=BIGINT}, #{poraDniaId,jdbcType=BIGINT})"
    })
    int insert(RealizacjaWrp record);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    int mergeInto(RealizacjaWrp record);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @InsertProvider(type=RealizacjaWrpSqlProvider.class, method="insertSelective")
    int insertSelective(RealizacjaWrp record);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @SelectProvider(type=RealizacjaWrpSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="OPERACJA_ID", property="operacjaId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="PORA_DNIA_ID", property="poraDniaId", jdbcType=JdbcType.BIGINT)
    })
    List<RealizacjaWrp> selectByExampleWithRowbounds(RealizacjaWrpCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @SelectProvider(type=RealizacjaWrpSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="OPERACJA_ID", property="operacjaId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="PORA_DNIA_ID", property="poraDniaId", jdbcType=JdbcType.BIGINT)
    })
    List<RealizacjaWrp> selectByExample(RealizacjaWrpCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @Select({
        "select",
        "OPERACJA_ID, PORA_DNIA_ID",
        "from REALIZACJA_WRP",
        "where OPERACJA_ID = #{operacjaId,jdbcType=BIGINT}"
    })
    @Results({
        @Result(column="OPERACJA_ID", property="operacjaId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="PORA_DNIA_ID", property="poraDniaId", jdbcType=JdbcType.BIGINT)
    })
    RealizacjaWrp selectByPrimaryKey(Long operacjaId);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @UpdateProvider(type=RealizacjaWrpSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") RealizacjaWrp record, @Param("example") RealizacjaWrpCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @UpdateProvider(type=RealizacjaWrpSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") RealizacjaWrp record, @Param("example") RealizacjaWrpCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @UpdateProvider(type=RealizacjaWrpSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(RealizacjaWrp record);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @Update({
        "update REALIZACJA_WRP",
        "set PORA_DNIA_ID = #{poraDniaId,jdbcType=BIGINT}",
        "where OPERACJA_ID = #{operacjaId,jdbcType=BIGINT}"
    })
    int updateByPrimaryKey(RealizacjaWrp record);
}