package pl.topteam.dps.dao.main_gen;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import pl.topteam.dps.model.main.Recepta;
import pl.topteam.dps.model.main_gen.ReceptaCriteria.Criteria;
import pl.topteam.dps.model.main_gen.ReceptaCriteria.Criterion;
import pl.topteam.dps.model.main.ReceptaCriteria;

public class ReceptaSqlProvider {

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String countByExample(ReceptaCriteria example) {
        SQL sql = new SQL();
        sql.SELECT("count(*)").FROM("RECEPTA");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String deleteByExample(ReceptaCriteria example) {
        SQL sql = new SQL();
        sql.DELETE_FROM("RECEPTA");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String insertSelective(Recepta record) {
        SQL sql = new SQL();
        sql.INSERT_INTO("RECEPTA");
        
        if (record.getEwidencjaDpsId() != null) {
            sql.VALUES("EWIDENCJA_DPS_ID", "#{ewidencjaDpsId,jdbcType=BIGINT}");
        }
        
        if (record.getLekarzWystawilId() != null) {
            sql.VALUES("LEKARZ_WYSTAWIL_ID", "#{lekarzWystawilId,jdbcType=BIGINT}");
        }
        
        if (record.getChorobyPrzewlekle() != null) {
            sql.VALUES("CHOROBY_PRZEWLEKLE", "#{chorobyPrzewlekle,jdbcType=VARCHAR}");
        }
        
        if (record.getDataWystawienia() != null) {
            sql.VALUES("DATA_WYSTAWIENIA", "#{dataWystawienia,jdbcType=DATE}");
        }
        
        if (record.getOddzialNfz() != null) {
            sql.VALUES("ODDZIAL_NFZ", "#{oddzialNfz,jdbcType=VARCHAR}");
        }
        
        if (record.getUprawnienie() != null) {
            sql.VALUES("UPRAWNIENIE", "#{uprawnienie,jdbcType=VARCHAR}");
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String selectByExample(ReceptaCriteria example) {
        SQL sql = new SQL();
        if (example != null && example.isDistinct()) {
            sql.SELECT_DISTINCT("ID");
        } else {
            sql.SELECT("ID");
        }
        sql.SELECT("EWIDENCJA_DPS_ID");
        sql.SELECT("LEKARZ_WYSTAWIL_ID");
        sql.SELECT("CHOROBY_PRZEWLEKLE");
        sql.SELECT("DATA_WYSTAWIENIA");
        sql.SELECT("ODDZIAL_NFZ");
        sql.SELECT("UPRAWNIENIE");
        sql.FROM("RECEPTA");
        applyWhere(sql, example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            sql.ORDER_BY(example.getOrderByClause());
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String updateByExampleSelective(Map<String, Object> parameter) {
        Recepta record = (Recepta) parameter.get("record");
        ReceptaCriteria example = (ReceptaCriteria) parameter.get("example");
        
        SQL sql = new SQL();
        sql.UPDATE("RECEPTA");
        
        if (record.getId() != null) {
            sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        }
        
        if (record.getEwidencjaDpsId() != null) {
            sql.SET("EWIDENCJA_DPS_ID = #{record.ewidencjaDpsId,jdbcType=BIGINT}");
        }
        
        if (record.getLekarzWystawilId() != null) {
            sql.SET("LEKARZ_WYSTAWIL_ID = #{record.lekarzWystawilId,jdbcType=BIGINT}");
        }
        
        if (record.getChorobyPrzewlekle() != null) {
            sql.SET("CHOROBY_PRZEWLEKLE = #{record.chorobyPrzewlekle,jdbcType=VARCHAR}");
        }
        
        if (record.getDataWystawienia() != null) {
            sql.SET("DATA_WYSTAWIENIA = #{record.dataWystawienia,jdbcType=DATE}");
        }
        
        if (record.getOddzialNfz() != null) {
            sql.SET("ODDZIAL_NFZ = #{record.oddzialNfz,jdbcType=VARCHAR}");
        }
        
        if (record.getUprawnienie() != null) {
            sql.SET("UPRAWNIENIE = #{record.uprawnienie,jdbcType=VARCHAR}");
        }
        
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String updateByExample(Map<String, Object> parameter) {
        SQL sql = new SQL();
        sql.UPDATE("RECEPTA");
        
        sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        sql.SET("EWIDENCJA_DPS_ID = #{record.ewidencjaDpsId,jdbcType=BIGINT}");
        sql.SET("LEKARZ_WYSTAWIL_ID = #{record.lekarzWystawilId,jdbcType=BIGINT}");
        sql.SET("CHOROBY_PRZEWLEKLE = #{record.chorobyPrzewlekle,jdbcType=VARCHAR}");
        sql.SET("DATA_WYSTAWIENIA = #{record.dataWystawienia,jdbcType=DATE}");
        sql.SET("ODDZIAL_NFZ = #{record.oddzialNfz,jdbcType=VARCHAR}");
        sql.SET("UPRAWNIENIE = #{record.uprawnienie,jdbcType=VARCHAR}");
        
        ReceptaCriteria example = (ReceptaCriteria) parameter.get("example");
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String updateByPrimaryKeySelective(Recepta record) {
        SQL sql = new SQL();
        sql.UPDATE("RECEPTA");
        
        if (record.getEwidencjaDpsId() != null) {
            sql.SET("EWIDENCJA_DPS_ID = #{ewidencjaDpsId,jdbcType=BIGINT}");
        }
        
        if (record.getLekarzWystawilId() != null) {
            sql.SET("LEKARZ_WYSTAWIL_ID = #{lekarzWystawilId,jdbcType=BIGINT}");
        }
        
        if (record.getChorobyPrzewlekle() != null) {
            sql.SET("CHOROBY_PRZEWLEKLE = #{chorobyPrzewlekle,jdbcType=VARCHAR}");
        }
        
        if (record.getDataWystawienia() != null) {
            sql.SET("DATA_WYSTAWIENIA = #{dataWystawienia,jdbcType=DATE}");
        }
        
        if (record.getOddzialNfz() != null) {
            sql.SET("ODDZIAL_NFZ = #{oddzialNfz,jdbcType=VARCHAR}");
        }
        
        if (record.getUprawnienie() != null) {
            sql.SET("UPRAWNIENIE = #{uprawnienie,jdbcType=VARCHAR}");
        }
        
        sql.WHERE("ID = #{id,jdbcType=BIGINT}");
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    protected void applyWhere(SQL sql, ReceptaCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            sql.WHERE(sb.toString());
        }
    }
}