package pl.topteam.dps.dao.main_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectKey;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.dps.model.main.Sad;
import pl.topteam.dps.model.main.SadCriteria;

public abstract interface SadMapper {
    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @SelectProvider(type=SadSqlProvider.class, method="countByExample")
    int countByExample(SadCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @DeleteProvider(type=SadSqlProvider.class, method="deleteByExample")
    int deleteByExample(SadCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @Delete({
        "delete from SAD",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int deleteByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @Insert({
        "insert into SAD (ADRES_ID, NAZWA)",
        "values (#{adresId,jdbcType=BIGINT}, #{nazwa,jdbcType=VARCHAR})"
    })
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insert(Sad record);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    int mergeInto(Sad record);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @InsertProvider(type=SadSqlProvider.class, method="insertSelective")
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insertSelective(Sad record);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @SelectProvider(type=SadSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="ADRES_ID", property="adresId", jdbcType=JdbcType.BIGINT),
        @Result(column="NAZWA", property="nazwa", jdbcType=JdbcType.VARCHAR)
    })
    List<Sad> selectByExampleWithRowbounds(SadCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @SelectProvider(type=SadSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="ADRES_ID", property="adresId", jdbcType=JdbcType.BIGINT),
        @Result(column="NAZWA", property="nazwa", jdbcType=JdbcType.VARCHAR)
    })
    List<Sad> selectByExample(SadCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @Select({
        "select",
        "ID, ADRES_ID, NAZWA",
        "from SAD",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="ADRES_ID", property="adresId", jdbcType=JdbcType.BIGINT),
        @Result(column="NAZWA", property="nazwa", jdbcType=JdbcType.VARCHAR)
    })
    Sad selectByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @UpdateProvider(type=SadSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") Sad record, @Param("example") SadCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @UpdateProvider(type=SadSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") Sad record, @Param("example") SadCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @UpdateProvider(type=SadSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(Sad record);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @Update({
        "update SAD",
        "set ADRES_ID = #{adresId,jdbcType=BIGINT},",
          "NAZWA = #{nazwa,jdbcType=VARCHAR}",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int updateByPrimaryKey(Sad record);
}