package pl.topteam.dps.dao.main_gen;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import pl.topteam.dps.model.main.SwiadczenieDodatek;
import pl.topteam.dps.model.main_gen.SwiadczenieDodatekCriteria.Criteria;
import pl.topteam.dps.model.main_gen.SwiadczenieDodatekCriteria.Criterion;
import pl.topteam.dps.model.main.SwiadczenieDodatekCriteria;

public class SwiadczenieDodatekSqlProvider {

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String countByExample(SwiadczenieDodatekCriteria example) {
        SQL sql = new SQL();
        sql.SELECT("count(*)").FROM("SWIADCZENIE_DODATEK");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String deleteByExample(SwiadczenieDodatekCriteria example) {
        SQL sql = new SQL();
        sql.DELETE_FROM("SWIADCZENIE_DODATEK");
        applyWhere(sql, example, false);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String insertSelective(SwiadczenieDodatek record) {
        SQL sql = new SQL();
        sql.INSERT_INTO("SWIADCZENIE_DODATEK");
        
        if (record.getPobieraneSwiadczenieId() != null) {
            sql.VALUES("POBIERANE_SWIADCZENIE_ID", "#{pobieraneSwiadczenieId,jdbcType=BIGINT}");
        }
        
        if (record.getKodDodatkuId() != null) {
            sql.VALUES("KOD_DODATKU_ID", "#{kodDodatkuId,jdbcType=BIGINT}");
        }
        
        if (record.getEkwiwalent() != null) {
            sql.VALUES("EKWIWALENT", "#{ekwiwalent,jdbcType=DECIMAL}");
        }
        
        if (record.getWartosc() != null) {
            sql.VALUES("WARTOSC", "#{wartosc,jdbcType=DECIMAL}");
        }
        
        if (record.getJednostka() != null) {
            sql.VALUES("JEDNOSTKA", "#{jednostka,jdbcType=VARCHAR}");
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String selectByExample(SwiadczenieDodatekCriteria example) {
        SQL sql = new SQL();
        if (example != null && example.isDistinct()) {
            sql.SELECT_DISTINCT("ID");
        } else {
            sql.SELECT("ID");
        }
        sql.SELECT("POBIERANE_SWIADCZENIE_ID");
        sql.SELECT("KOD_DODATKU_ID");
        sql.SELECT("EKWIWALENT");
        sql.SELECT("WARTOSC");
        sql.SELECT("JEDNOSTKA");
        sql.FROM("SWIADCZENIE_DODATEK");
        applyWhere(sql, example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            sql.ORDER_BY(example.getOrderByClause());
        }
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String updateByExampleSelective(Map<String, Object> parameter) {
        SwiadczenieDodatek record = (SwiadczenieDodatek) parameter.get("record");
        SwiadczenieDodatekCriteria example = (SwiadczenieDodatekCriteria) parameter.get("example");
        
        SQL sql = new SQL();
        sql.UPDATE("SWIADCZENIE_DODATEK");
        
        if (record.getId() != null) {
            sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        }
        
        if (record.getPobieraneSwiadczenieId() != null) {
            sql.SET("POBIERANE_SWIADCZENIE_ID = #{record.pobieraneSwiadczenieId,jdbcType=BIGINT}");
        }
        
        if (record.getKodDodatkuId() != null) {
            sql.SET("KOD_DODATKU_ID = #{record.kodDodatkuId,jdbcType=BIGINT}");
        }
        
        if (record.getEkwiwalent() != null) {
            sql.SET("EKWIWALENT = #{record.ekwiwalent,jdbcType=DECIMAL}");
        }
        
        if (record.getWartosc() != null) {
            sql.SET("WARTOSC = #{record.wartosc,jdbcType=DECIMAL}");
        }
        
        if (record.getJednostka() != null) {
            sql.SET("JEDNOSTKA = #{record.jednostka,jdbcType=VARCHAR}");
        }
        
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String updateByExample(Map<String, Object> parameter) {
        SQL sql = new SQL();
        sql.UPDATE("SWIADCZENIE_DODATEK");
        
        sql.SET("ID = #{record.id,jdbcType=BIGINT}");
        sql.SET("POBIERANE_SWIADCZENIE_ID = #{record.pobieraneSwiadczenieId,jdbcType=BIGINT}");
        sql.SET("KOD_DODATKU_ID = #{record.kodDodatkuId,jdbcType=BIGINT}");
        sql.SET("EKWIWALENT = #{record.ekwiwalent,jdbcType=DECIMAL}");
        sql.SET("WARTOSC = #{record.wartosc,jdbcType=DECIMAL}");
        sql.SET("JEDNOSTKA = #{record.jednostka,jdbcType=VARCHAR}");
        
        SwiadczenieDodatekCriteria example = (SwiadczenieDodatekCriteria) parameter.get("example");
        applyWhere(sql, example, true);
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    public String updateByPrimaryKeySelective(SwiadczenieDodatek record) {
        SQL sql = new SQL();
        sql.UPDATE("SWIADCZENIE_DODATEK");
        
        if (record.getPobieraneSwiadczenieId() != null) {
            sql.SET("POBIERANE_SWIADCZENIE_ID = #{pobieraneSwiadczenieId,jdbcType=BIGINT}");
        }
        
        if (record.getKodDodatkuId() != null) {
            sql.SET("KOD_DODATKU_ID = #{kodDodatkuId,jdbcType=BIGINT}");
        }
        
        if (record.getEkwiwalent() != null) {
            sql.SET("EKWIWALENT = #{ekwiwalent,jdbcType=DECIMAL}");
        }
        
        if (record.getWartosc() != null) {
            sql.SET("WARTOSC = #{wartosc,jdbcType=DECIMAL}");
        }
        
        if (record.getJednostka() != null) {
            sql.SET("JEDNOSTKA = #{jednostka,jdbcType=VARCHAR}");
        }
        
        sql.WHERE("ID = #{id,jdbcType=BIGINT}");
        
        return sql.toString();
    }

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    protected void applyWhere(SQL sql, SwiadczenieDodatekCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            sql.WHERE(sb.toString());
        }
    }
}