package pl.topteam.dps.dao.main_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectKey;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.dps.model.main.Swiadczenie;
import pl.topteam.dps.model.main.SwiadczenieCriteria;

public abstract interface SwiadczenieMapper {
    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @SelectProvider(type=SwiadczenieSqlProvider.class, method="countByExample")
    int countByExample(SwiadczenieCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @DeleteProvider(type=SwiadczenieSqlProvider.class, method="deleteByExample")
    int deleteByExample(SwiadczenieCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @Delete({
        "delete from SWIADCZENIE",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int deleteByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @Insert({
        "insert into SWIADCZENIE (GRUPA_ID, ROZLICZAJ_W_RAMACH_ID, ",
        "NAZWA, JEDNOSTKA, ",
        "KOLEJNOSC_WYDRUK, SKROT_WYDRUK)",
        "values (#{grupaId,jdbcType=BIGINT}, #{rozliczajWRamachId,jdbcType=BIGINT}, ",
        "#{nazwa,jdbcType=VARCHAR}, #{jednostka,jdbcType=VARCHAR}, ",
        "#{kolejnoscWydruk,jdbcType=INTEGER}, #{skrotWydruk,jdbcType=VARCHAR})"
    })
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insert(Swiadczenie record);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    int mergeInto(Swiadczenie record);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @InsertProvider(type=SwiadczenieSqlProvider.class, method="insertSelective")
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insertSelective(Swiadczenie record);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @SelectProvider(type=SwiadczenieSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="GRUPA_ID", property="grupaId", jdbcType=JdbcType.BIGINT),
        @Result(column="ROZLICZAJ_W_RAMACH_ID", property="rozliczajWRamachId", jdbcType=JdbcType.BIGINT),
        @Result(column="NAZWA", property="nazwa", jdbcType=JdbcType.VARCHAR),
        @Result(column="JEDNOSTKA", property="jednostka", jdbcType=JdbcType.VARCHAR),
        @Result(column="KOLEJNOSC_WYDRUK", property="kolejnoscWydruk", jdbcType=JdbcType.INTEGER),
        @Result(column="SKROT_WYDRUK", property="skrotWydruk", jdbcType=JdbcType.VARCHAR)
    })
    List<Swiadczenie> selectByExampleWithRowbounds(SwiadczenieCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @SelectProvider(type=SwiadczenieSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="GRUPA_ID", property="grupaId", jdbcType=JdbcType.BIGINT),
        @Result(column="ROZLICZAJ_W_RAMACH_ID", property="rozliczajWRamachId", jdbcType=JdbcType.BIGINT),
        @Result(column="NAZWA", property="nazwa", jdbcType=JdbcType.VARCHAR),
        @Result(column="JEDNOSTKA", property="jednostka", jdbcType=JdbcType.VARCHAR),
        @Result(column="KOLEJNOSC_WYDRUK", property="kolejnoscWydruk", jdbcType=JdbcType.INTEGER),
        @Result(column="SKROT_WYDRUK", property="skrotWydruk", jdbcType=JdbcType.VARCHAR)
    })
    List<Swiadczenie> selectByExample(SwiadczenieCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @Select({
        "select",
        "ID, GRUPA_ID, ROZLICZAJ_W_RAMACH_ID, NAZWA, JEDNOSTKA, KOLEJNOSC_WYDRUK, SKROT_WYDRUK",
        "from SWIADCZENIE",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="GRUPA_ID", property="grupaId", jdbcType=JdbcType.BIGINT),
        @Result(column="ROZLICZAJ_W_RAMACH_ID", property="rozliczajWRamachId", jdbcType=JdbcType.BIGINT),
        @Result(column="NAZWA", property="nazwa", jdbcType=JdbcType.VARCHAR),
        @Result(column="JEDNOSTKA", property="jednostka", jdbcType=JdbcType.VARCHAR),
        @Result(column="KOLEJNOSC_WYDRUK", property="kolejnoscWydruk", jdbcType=JdbcType.INTEGER),
        @Result(column="SKROT_WYDRUK", property="skrotWydruk", jdbcType=JdbcType.VARCHAR)
    })
    Swiadczenie selectByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @UpdateProvider(type=SwiadczenieSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") Swiadczenie record, @Param("example") SwiadczenieCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @UpdateProvider(type=SwiadczenieSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") Swiadczenie record, @Param("example") SwiadczenieCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @UpdateProvider(type=SwiadczenieSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(Swiadczenie record);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @Update({
        "update SWIADCZENIE",
        "set GRUPA_ID = #{grupaId,jdbcType=BIGINT},",
          "ROZLICZAJ_W_RAMACH_ID = #{rozliczajWRamachId,jdbcType=BIGINT},",
          "NAZWA = #{nazwa,jdbcType=VARCHAR},",
          "JEDNOSTKA = #{jednostka,jdbcType=VARCHAR},",
          "KOLEJNOSC_WYDRUK = #{kolejnoscWydruk,jdbcType=INTEGER},",
          "SKROT_WYDRUK = #{skrotWydruk,jdbcType=VARCHAR}",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int updateByPrimaryKey(Swiadczenie record);
}