package pl.topteam.dps.dao.main_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.dps.model.main.SwiadczenieRealizacja;
import pl.topteam.dps.model.main.SwiadczenieRealizacjaCriteria;
import pl.topteam.dps.model.main_gen.SwiadczenieRealizacjaKey;

public abstract interface SwiadczenieRealizacjaMapper {
    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @SelectProvider(type=SwiadczenieRealizacjaSqlProvider.class, method="countByExample")
    int countByExample(SwiadczenieRealizacjaCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @DeleteProvider(type=SwiadczenieRealizacjaSqlProvider.class, method="deleteByExample")
    int deleteByExample(SwiadczenieRealizacjaCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @Delete({
        "delete from SWIADCZENIE_REALIZACJA",
        "where SWIADCZENIE_ID = #{swiadczenieId,jdbcType=BIGINT}",
          "and DATA = #{data,jdbcType=DATE}",
          "and MIESZKANIEC_ID = #{mieszkaniecId,jdbcType=BIGINT}"
    })
    int deleteByPrimaryKey(SwiadczenieRealizacjaKey key);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @Insert({
        "insert into SWIADCZENIE_REALIZACJA (SWIADCZENIE_ID, DATA, ",
        "MIESZKANIEC_ID, ILOSC, ",
        "ILOSC_REZYGNACJA, ILOSC_PELNOPLATNE)",
        "values (#{swiadczenieId,jdbcType=BIGINT}, #{data,jdbcType=DATE}, ",
        "#{mieszkaniecId,jdbcType=BIGINT}, #{ilosc,jdbcType=DECIMAL}, ",
        "#{iloscRezygnacja,jdbcType=DECIMAL}, #{iloscPelnoplatne,jdbcType=DECIMAL})"
    })
    int insert(SwiadczenieRealizacja record);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    int mergeInto(SwiadczenieRealizacja record);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @InsertProvider(type=SwiadczenieRealizacjaSqlProvider.class, method="insertSelective")
    int insertSelective(SwiadczenieRealizacja record);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @SelectProvider(type=SwiadczenieRealizacjaSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="SWIADCZENIE_ID", property="swiadczenieId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="DATA", property="data", jdbcType=JdbcType.DATE, id=true),
        @Result(column="MIESZKANIEC_ID", property="mieszkaniecId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="ILOSC", property="ilosc", jdbcType=JdbcType.DECIMAL),
        @Result(column="ILOSC_REZYGNACJA", property="iloscRezygnacja", jdbcType=JdbcType.DECIMAL),
        @Result(column="ILOSC_PELNOPLATNE", property="iloscPelnoplatne", jdbcType=JdbcType.DECIMAL)
    })
    List<SwiadczenieRealizacja> selectByExampleWithRowbounds(SwiadczenieRealizacjaCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @SelectProvider(type=SwiadczenieRealizacjaSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="SWIADCZENIE_ID", property="swiadczenieId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="DATA", property="data", jdbcType=JdbcType.DATE, id=true),
        @Result(column="MIESZKANIEC_ID", property="mieszkaniecId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="ILOSC", property="ilosc", jdbcType=JdbcType.DECIMAL),
        @Result(column="ILOSC_REZYGNACJA", property="iloscRezygnacja", jdbcType=JdbcType.DECIMAL),
        @Result(column="ILOSC_PELNOPLATNE", property="iloscPelnoplatne", jdbcType=JdbcType.DECIMAL)
    })
    List<SwiadczenieRealizacja> selectByExample(SwiadczenieRealizacjaCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @Select({
        "select",
        "SWIADCZENIE_ID, DATA, MIESZKANIEC_ID, ILOSC, ILOSC_REZYGNACJA, ILOSC_PELNOPLATNE",
        "from SWIADCZENIE_REALIZACJA",
        "where SWIADCZENIE_ID = #{swiadczenieId,jdbcType=BIGINT}",
          "and DATA = #{data,jdbcType=DATE}",
          "and MIESZKANIEC_ID = #{mieszkaniecId,jdbcType=BIGINT}"
    })
    @Results({
        @Result(column="SWIADCZENIE_ID", property="swiadczenieId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="DATA", property="data", jdbcType=JdbcType.DATE, id=true),
        @Result(column="MIESZKANIEC_ID", property="mieszkaniecId", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="ILOSC", property="ilosc", jdbcType=JdbcType.DECIMAL),
        @Result(column="ILOSC_REZYGNACJA", property="iloscRezygnacja", jdbcType=JdbcType.DECIMAL),
        @Result(column="ILOSC_PELNOPLATNE", property="iloscPelnoplatne", jdbcType=JdbcType.DECIMAL)
    })
    SwiadczenieRealizacja selectByPrimaryKey(SwiadczenieRealizacjaKey key);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @UpdateProvider(type=SwiadczenieRealizacjaSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") SwiadczenieRealizacja record, @Param("example") SwiadczenieRealizacjaCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @UpdateProvider(type=SwiadczenieRealizacjaSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") SwiadczenieRealizacja record, @Param("example") SwiadczenieRealizacjaCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @UpdateProvider(type=SwiadczenieRealizacjaSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(SwiadczenieRealizacja record);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @Update({
        "update SWIADCZENIE_REALIZACJA",
        "set ILOSC = #{ilosc,jdbcType=DECIMAL},",
          "ILOSC_REZYGNACJA = #{iloscRezygnacja,jdbcType=DECIMAL},",
          "ILOSC_PELNOPLATNE = #{iloscPelnoplatne,jdbcType=DECIMAL}",
        "where SWIADCZENIE_ID = #{swiadczenieId,jdbcType=BIGINT}",
          "and DATA = #{data,jdbcType=DATE}",
          "and MIESZKANIEC_ID = #{mieszkaniecId,jdbcType=BIGINT}"
    })
    int updateByPrimaryKey(SwiadczenieRealizacja record);
}