package pl.topteam.dps.dao.main_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectKey;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.dps.model.main.Zadluzenie;
import pl.topteam.dps.model.main.ZadluzenieCriteria;

public abstract interface ZadluzenieMapper {
    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @SelectProvider(type=ZadluzenieSqlProvider.class, method="countByExample")
    int countByExample(ZadluzenieCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @DeleteProvider(type=ZadluzenieSqlProvider.class, method="deleteByExample")
    int deleteByExample(ZadluzenieCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @Delete({
        "delete from ZADLUZENIE",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int deleteByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @Insert({
        "insert into ZADLUZENIE (OSOBA_ID, MIESIAC, ",
        "ROK, AKTUALNOSC)",
        "values (#{osobaId,jdbcType=BIGINT}, #{miesiac,jdbcType=INTEGER}, ",
        "#{rok,jdbcType=INTEGER}, #{aktualnosc,jdbcType=VARCHAR})"
    })
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insert(Zadluzenie record);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    int mergeInto(Zadluzenie record);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @InsertProvider(type=ZadluzenieSqlProvider.class, method="insertSelective")
    @SelectKey(statement="CALL IDENTITY()", keyProperty="id", before=false, resultType=Long.class)
    int insertSelective(Zadluzenie record);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @SelectProvider(type=ZadluzenieSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="OSOBA_ID", property="osobaId", jdbcType=JdbcType.BIGINT),
        @Result(column="MIESIAC", property="miesiac", jdbcType=JdbcType.INTEGER),
        @Result(column="ROK", property="rok", jdbcType=JdbcType.INTEGER),
        @Result(column="AKTUALNOSC", property="aktualnosc", jdbcType=JdbcType.VARCHAR)
    })
    List<Zadluzenie> selectByExampleWithRowbounds(ZadluzenieCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @SelectProvider(type=ZadluzenieSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="OSOBA_ID", property="osobaId", jdbcType=JdbcType.BIGINT),
        @Result(column="MIESIAC", property="miesiac", jdbcType=JdbcType.INTEGER),
        @Result(column="ROK", property="rok", jdbcType=JdbcType.INTEGER),
        @Result(column="AKTUALNOSC", property="aktualnosc", jdbcType=JdbcType.VARCHAR)
    })
    List<Zadluzenie> selectByExample(ZadluzenieCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @Select({
        "select",
        "ID, OSOBA_ID, MIESIAC, ROK, AKTUALNOSC",
        "from ZADLUZENIE",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    @Results({
        @Result(column="ID", property="id", jdbcType=JdbcType.BIGINT, id=true),
        @Result(column="OSOBA_ID", property="osobaId", jdbcType=JdbcType.BIGINT),
        @Result(column="MIESIAC", property="miesiac", jdbcType=JdbcType.INTEGER),
        @Result(column="ROK", property="rok", jdbcType=JdbcType.INTEGER),
        @Result(column="AKTUALNOSC", property="aktualnosc", jdbcType=JdbcType.VARCHAR)
    })
    Zadluzenie selectByPrimaryKey(Long id);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @UpdateProvider(type=ZadluzenieSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") Zadluzenie record, @Param("example") ZadluzenieCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @UpdateProvider(type=ZadluzenieSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") Zadluzenie record, @Param("example") ZadluzenieCriteria example);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @UpdateProvider(type=ZadluzenieSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(Zadluzenie record);

    /**
     * @mbggenerated 2014-03-17 12:09:20
     */
    @Update({
        "update ZADLUZENIE",
        "set OSOBA_ID = #{osobaId,jdbcType=BIGINT},",
          "MIESIAC = #{miesiac,jdbcType=INTEGER},",
          "ROK = #{rok,jdbcType=INTEGER},",
          "AKTUALNOSC = #{aktualnosc,jdbcType=VARCHAR}",
        "where ID = #{id,jdbcType=BIGINT}"
    })
    int updateByPrimaryKey(Zadluzenie record);
}